/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.access.ClientServerChannel;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.remote.service.DispatchHelper;
import org.apache.cayenne.remote.service.MissingSessionException;
import org.apache.cayenne.remote.service.ServerSession;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseRemoteService
implements RemoteService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected ObjectContextFactory contextFactory;
    protected String eventBridgeFactoryName;
    protected Map<String, String> eventBridgeParameters;

    public BaseRemoteService(ObjectContextFactory contextFactory, Map<String, String> eventBridgeProperties) {
        this.logger.debug((Object)"ROP service is starting");
        this.contextFactory = contextFactory;
        this.initEventBridgeParameters(eventBridgeProperties);
        this.logger.debug((Object)(this.getClass().getName() + " started"));
    }

    public String getEventBridgeFactoryName() {
        return this.eventBridgeFactoryName;
    }

    public Map<String, String> getEventBridgeParameters() {
        return this.eventBridgeParameters != null ? Collections.unmodifiableMap(this.eventBridgeParameters) : Collections.EMPTY_MAP;
    }

    protected abstract ServerSession createServerSession();

    protected abstract ServerSession createServerSession(String var1);

    protected abstract ServerSession getServerSession();

    @Override
    public RemoteSession establishSession() {
        this.logger.debug((Object)"Session requested by client");
        RemoteSession session = this.createServerSession().getSession();
        this.logger.debug((Object)("Established client session: " + session));
        return session;
    }

    @Override
    public RemoteSession establishSharedSession(String name) {
        this.logger.debug((Object)("Shared session requested by client. Group name: " + name));
        if (name == null) {
            throw new CayenneRuntimeException("Invalid null shared session name", new Object[0]);
        }
        return this.createServerSession(name).getSession();
    }

    @Override
    public Object processMessage(ClientMessage message) throws Throwable {
        if (message == null) {
            throw new IllegalArgumentException("Null client message.");
        }
        ServerSession handler = this.getServerSession();
        if (handler == null) {
            throw new MissingSessionException("No session associated with request.", new Object[0]);
        }
        this.logger.debug((Object)("processMessage, sessionId: " + handler.getSession().getSessionId()));
        try {
            return DispatchHelper.dispatch(handler.getChannel(), message);
        }
        catch (Throwable th) {
            StringBuilder wrapperMessage = new StringBuilder();
            wrapperMessage.append("Exception processing message ").append(message.getClass().getName()).append(" of type ").append(message);
            String wrapperMessageString = wrapperMessage.toString();
            this.logger.info((Object)wrapperMessageString, th);
            Exception cause = new Exception(Util.unwindException(th).getLocalizedMessage());
            throw new CayenneRuntimeException(wrapperMessageString, (Throwable)cause, new Object[0]);
        }
    }

    protected RemoteSession createRemoteSession(String sessionId, String name, boolean enableEvents) {
        RemoteSession session = enableEvents ? new RemoteSession(sessionId, this.eventBridgeFactoryName, this.eventBridgeParameters) : new RemoteSession(sessionId);
        session.setName(name);
        return session;
    }

    protected DataChannel createChannel() {
        return new ClientServerChannel((DataContext)this.contextFactory.createContext());
    }

    protected void initEventBridgeParameters(Map<String, String> properties) {
        String eventBridgeFactoryName = properties.get("cayenne.server.rop_event_bridge_factory");
        if (eventBridgeFactoryName != null) {
            HashMap<String, String> eventBridgeParameters = new HashMap<String, String>(properties);
            eventBridgeParameters.remove("cayenne.server.rop_event_bridge_factory");
            this.eventBridgeFactoryName = eventBridgeFactoryName;
            this.eventBridgeParameters = eventBridgeParameters;
        }
    }
}

