/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.loader.DbLoaderConfiguration;
import org.apache.cayenne.access.loader.DefaultDbLoaderDelegate;
import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.FiltersConfig;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DetectedDbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.AddRelationshipToDb;
import org.apache.cayenne.merge.EmptyValueForNullProvider;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.ValueForNullProvider;

public class DbMerger {
    private final MergerFactory factory;
    private final ValueForNullProvider valueForNull;

    public DbMerger(MergerFactory factory) {
        this(factory, null);
    }

    public DbMerger(MergerFactory factory, ValueForNullProvider valueForNull) {
        this.factory = factory;
        this.valueForNull = valueForNull == null ? new EmptyValueForNullProvider() : valueForNull;
    }

    public List<MergerToken> createMergeTokens(DataSource dataSource, DbAdapter adapter, DataMap existingDataMap, DbLoaderConfiguration config) {
        return this.createMergeTokens(existingDataMap, this.loadDataMapFromDb(dataSource, adapter, config), config);
    }

    public List<MergerToken> createMergeTokens(DataMap existing, DataMap loadedFomDb, DbLoaderConfiguration config) {
        loadedFomDb.setQuotingSQLIdentifiers(existing.isQuotingSQLIdentifiers());
        List<MergerToken> tokens = this.createMergeTokens(this.filter(existing, config.getFiltersConfig()), loadedFomDb.getDbEntities(), config);
        Collections.sort(tokens, new Comparator<MergerToken>(){

            @Override
            public int compare(MergerToken o1, MergerToken o2) {
                if (o1 instanceof AbstractToDbToken && o2 instanceof AbstractToDbToken) {
                    return ((AbstractToDbToken)o1).compareTo(o2);
                }
                return 0;
            }
        });
        return tokens;
    }

    private Collection<DbEntity> filter(DataMap existing, FiltersConfig filtersConfig) {
        LinkedList<DbEntity> existingFiltered = new LinkedList<DbEntity>();
        for (DbEntity entity : existing.getDbEntities()) {
            if (!filtersConfig.filter(DbPath.build(entity)).tableFilter().isInclude(entity)) continue;
            existingFiltered.add(entity);
        }
        return existingFiltered;
    }

    private DataMap loadDataMapFromDb(DataSource dataSource, DbAdapter adapter, DbLoaderConfiguration config) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            DataMap dataMap = new DbLoader(conn, adapter, new DefaultDbLoaderDelegate()).load(config);
            return dataMap;
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("Can't doLoad dataMap from db.", (Throwable)e, new Object[0]);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public List<MergerToken> createMergeTokens(Collection<DbEntity> existing, Collection<DbEntity> loadedFromDb, DbLoaderConfiguration config) {
        LinkedList<DbEntity> dbEntitiesToDrop = new LinkedList<DbEntity>(loadedFromDb);
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        for (DbEntity dbEntity : existing) {
            MergerToken token;
            String tableName = dbEntity.getName();
            DbEntity detectedEntity = this.findDbEntity(loadedFromDb, tableName);
            if (detectedEntity == null) {
                tokens.add(this.factory.createCreateTableToDb(dbEntity));
                for (DbRelationship rel : dbEntity.getRelationships()) {
                    tokens.add(this.factory.createAddRelationshipToDb(dbEntity, rel));
                }
                continue;
            }
            dbEntitiesToDrop.remove(detectedEntity);
            tokens.addAll(this.checkRelationshipsToDrop(dbEntity, detectedEntity));
            if (!config.isSkipRelationshipsLoading()) {
                tokens.addAll(this.checkRelationshipsToAdd(dbEntity, detectedEntity));
            }
            tokens.addAll(this.checkRows(dbEntity, detectedEntity));
            if (config.isSkipPrimaryKeyLoading() || (token = this.checkPrimaryKeyChange(dbEntity, detectedEntity)) == null) continue;
            tokens.add(token);
        }
        for (DbEntity e : dbEntitiesToDrop) {
            tokens.add(this.factory.createDropTableToDb(e));
            for (DbRelationship relationship : e.getRelationships()) {
                DbEntity detectedEntity = this.findDbEntity(existing, relationship.getTargetEntityName());
                if (detectedEntity == null) continue;
                tokens.add(this.factory.createDropRelationshipToDb(detectedEntity, relationship.getReverseRelationship()));
            }
        }
        return tokens;
    }

    private List<MergerToken> checkRows(DbEntity existing, DbEntity loadedFromDb) {
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        for (DbAttribute detected : loadedFromDb.getAttributes()) {
            if (this.findDbAttribute(existing, detected.getName()) != null) continue;
            tokens.add(this.factory.createDropColumnToDb(existing, detected));
        }
        for (DbAttribute attr : existing.getAttributes()) {
            String columnName = attr.getName().toUpperCase();
            DbAttribute detected = this.findDbAttribute(loadedFromDb, columnName);
            if (detected == null) {
                tokens.add(this.factory.createAddColumnToDb(existing, attr));
                if (!attr.isMandatory()) continue;
                if (this.valueForNull.hasValueFor(existing, attr)) {
                    tokens.add(this.factory.createSetValueForNullToDb(existing, attr, this.valueForNull));
                }
                tokens.add(this.factory.createSetNotNullToDb(existing, attr));
                continue;
            }
            if (attr.isMandatory() != detected.isMandatory()) {
                if (attr.isMandatory()) {
                    if (this.valueForNull.hasValueFor(existing, attr)) {
                        tokens.add(this.factory.createSetValueForNullToDb(existing, attr, this.valueForNull));
                    }
                    tokens.add(this.factory.createSetNotNullToDb(existing, attr));
                } else {
                    tokens.add(this.factory.createSetAllowNullToDb(existing, attr));
                }
            }
            switch (detected.getType()) {
                case 1: 
                case 12: {
                    if (attr.getMaxLength() == detected.getMaxLength()) break;
                    tokens.add(this.factory.createSetColumnTypeToDb(existing, detected, attr));
                }
            }
        }
        return tokens;
    }

    private List<MergerToken> checkRelationshipsToDrop(DbEntity dbEntity, DbEntity detectedEntity) {
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        for (DbRelationship detected : detectedEntity.getRelationships()) {
            DbEntity targetEntity;
            if (this.findDbRelationship(dbEntity, detected) != null || (targetEntity = this.findDbEntity(dbEntity.getDataMap().getDbEntities(), detected.getTargetEntityName())) == null) continue;
            detected.setSourceEntity(dbEntity);
            detected.setTargetEntityName(targetEntity);
            for (DbJoin join : detected.getJoins()) {
                DbAttribute tattr;
                DbAttribute sattr = this.findDbAttribute(dbEntity, join.getSourceName());
                if (sattr != null) {
                    join.setSourceName(sattr.getName());
                }
                if ((tattr = this.findDbAttribute(targetEntity, join.getTargetName())) == null) continue;
                join.setTargetName(tattr.getName());
            }
            MergerToken token = this.factory.createDropRelationshipToDb(dbEntity, detected);
            if (detected.isToMany()) {
                token = token.createReverse(this.factory);
            }
            tokens.add(token);
        }
        return tokens;
    }

    private List<MergerToken> checkRelationshipsToAdd(DbEntity dbEntity, DbEntity detectedEntity) {
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        for (DbRelationship rel : dbEntity.getRelationships()) {
            AddRelationshipToDb token;
            if (this.findDbRelationship(detectedEntity, rel) != null || !(token = (AddRelationshipToDb)this.factory.createAddRelationshipToDb(dbEntity, rel)).shouldGenerateFkConstraint()) continue;
            tokens.add(token);
        }
        return tokens;
    }

    private MergerToken checkPrimaryKeyChange(DbEntity dbEntity, DbEntity detectedEntity) {
        Collection<DbAttribute> primaryKeyOriginal = detectedEntity.getPrimaryKeys();
        Collection<DbAttribute> primaryKeyNew = dbEntity.getPrimaryKeys();
        String primaryKeyName = null;
        if (detectedEntity instanceof DetectedDbEntity) {
            primaryKeyName = ((DetectedDbEntity)detectedEntity).getPrimaryKeyName();
        }
        if (this.upperCaseEntityNames(primaryKeyOriginal).equals(this.upperCaseEntityNames(primaryKeyNew))) {
            return null;
        }
        return this.factory.createSetPrimaryKeyToDb(dbEntity, primaryKeyOriginal, primaryKeyNew, primaryKeyName);
    }

    private Set<String> upperCaseEntityNames(Collection<? extends Attribute> attrs) {
        HashSet<String> names = new HashSet<String>();
        for (Attribute attribute : attrs) {
            names.add(attribute.getName().toUpperCase());
        }
        return names;
    }

    private DbEntity findDbEntity(Collection<DbEntity> dbEntities, String caseInsensitiveName) {
        for (DbEntity e : dbEntities) {
            if (!e.getName().equalsIgnoreCase(caseInsensitiveName)) continue;
            return e;
        }
        return null;
    }

    private DbAttribute findDbAttribute(DbEntity entity, String caseInsensitiveName) {
        for (DbAttribute a : entity.getAttributes()) {
            if (!a.getName().equalsIgnoreCase(caseInsensitiveName)) continue;
            return a;
        }
        return null;
    }

    private DbRelationship findDbRelationship(DbEntity entity, DbRelationship rel) {
        for (DbRelationship candidate : entity.getRelationships()) {
            if (!DbMerger.equalDbJoinCollections(candidate.getJoins(), rel.getJoins())) continue;
            return candidate;
        }
        return null;
    }

    private static boolean equalDbJoinCollections(Collection<DbJoin> j1s, Collection<DbJoin> j2s) {
        if (j1s.size() != j2s.size()) {
            return false;
        }
        for (DbJoin j1 : j1s) {
            if (DbMerger.havePair(j2s, j1)) continue;
            return false;
        }
        return true;
    }

    private static boolean havePair(Collection<DbJoin> j2s, DbJoin j1) {
        for (DbJoin j2 : j2s) {
            if (DbMerger.isNull(j1.getSource()) || DbMerger.isNull(j1.getTarget()) || DbMerger.isNull(j2.getSource()) || DbMerger.isNull(j2.getTarget()) || !j1.getSource().getEntity().getName().equalsIgnoreCase(j2.getSource().getEntity().getName()) || !j1.getTarget().getEntity().getName().equalsIgnoreCase(j2.getTarget().getEntity().getName()) || !j1.getSourceName().equalsIgnoreCase(j2.getSourceName()) || !j1.getTargetName().equalsIgnoreCase(j2.getTargetName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNull(DbAttribute attribute) {
        return attribute == null || attribute.getEntity() == null;
    }
}

