/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

public class ByteType
implements ExtendedType {
    protected boolean widenBytes;

    public ByteType(boolean widenBytes) {
        this.widenBytes = widenBytes;
    }

    @Override
    public String getClassName() {
        return Byte.class.getName();
    }

    @Override
    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        byte b = rs.getByte(index);
        return rs.wasNull() ? null : Byte.valueOf(b);
    }

    @Override
    public Object materializeObject(CallableStatement st, int index, int type) throws Exception {
        byte b = st.getByte(index);
        return st.wasNull() ? null : Byte.valueOf(b);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int precision) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            Byte b = (Byte)value;
            if (this.widenBytes) {
                statement.setInt(pos, b.intValue());
            } else {
                statement.setByte(pos, b);
            }
        }
    }
}

