/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import org.apache.cayenne.access.translator.batch.BatchParameterBinding;
import org.apache.cayenne.access.translator.batch.DeleteBatchTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.DeleteBatchQuery;

public class SoftDeleteBatchTranslator
extends DeleteBatchTranslator {
    private String deletedFieldName;

    public SoftDeleteBatchTranslator(DeleteBatchQuery query, DbAdapter adapter, String trimFunction, String deletedFieldName) {
        super(query, adapter, trimFunction);
        this.deletedFieldName = deletedFieldName;
    }

    @Override
    protected String createSql() {
        QuotingStrategy strategy = this.adapter.getQuotingStrategy();
        StringBuilder buffer = new StringBuilder("UPDATE ");
        buffer.append(strategy.quotedFullyQualifiedName(this.query.getDbEntity()));
        buffer.append(" SET ").append(strategy.quotedIdentifier(this.query.getDbEntity(), this.deletedFieldName)).append(" = ?");
        this.applyQualifier(buffer);
        return buffer.toString();
    }

    @Override
    protected BatchParameterBinding[] createBindings() {
        BatchParameterBinding[] superBindings = super.createBindings();
        int slen = superBindings.length;
        BatchParameterBinding[] bindings = new BatchParameterBinding[slen + 1];
        DbAttribute deleteAttribute = this.query.getDbEntity().getAttribute(this.deletedFieldName);
        bindings[0] = new BatchParameterBinding(deleteAttribute);
        bindings[0].include(1, true);
        System.arraycopy(superBindings, 0, bindings, 1, slen);
        return bindings;
    }

    @Override
    protected BatchParameterBinding[] doUpdateBindings(BatchQueryRow row) {
        int len = this.bindings.length;
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)this.query;
        int j = 2;
        for (int i = 1; i < len; ++i) {
            BatchParameterBinding b = this.bindings[i];
            if (deleteBatch.isNull(b.getAttribute())) {
                b.exclude();
                continue;
            }
            b.include(j++, row.getValue(i - 1));
        }
        return this.bindings;
    }
}

