/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.velocity;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.MockOperationObserver;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ResultDirectiveIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private JdbcAdapter dbAdapter;
    @Inject
    private DataNode node;

    @Test
    public void testWithoutResultDirective() throws Exception {
        String sql = "SELECT ARTIST_ID, ARTIST_NAME FROM ARTIST";
        Map<String, Object> artist = this.insertArtist();
        Map<String, Object> selectResult = this.selectForQuery(sql);
        Assert.assertEquals((Object)artist.get("ARTIST_ID"), (Object)selectResult.get("ARTIST_ID"));
        Assert.assertEquals((Object)artist.get("ARTIST_NAME"), (Object)selectResult.get("ARTIST_NAME"));
    }

    @Test
    public void testWithOnlyResultDirective() throws Exception {
        String sql = "SELECT #result('ARTIST_ID' 'java.lang.Integer'), #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST";
        Map<String, Object> artist = this.insertArtist();
        Map<String, Object> selectResult = this.selectForQuery(sql);
        Assert.assertEquals((Object)artist.get("ARTIST_ID"), (Object)selectResult.get("ARTIST_ID"));
        Assert.assertEquals((Object)artist.get("ARTIST_NAME"), (Object)selectResult.get("ARTIST_NAME").toString().trim());
    }

    @Test
    public void testWithMixedDirectiveUse1() throws Exception {
        String sql = "SELECT ARTIST_ID, #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST";
        Map<String, Object> artist = this.insertArtist();
        Map<String, Object> selectResult = this.selectForQuery(sql);
        Assert.assertEquals((Object)artist.get("ARTIST_ID"), (Object)selectResult.get("ARTIST_ID"));
        Assert.assertEquals((Object)artist.get("ARTIST_NAME"), (Object)selectResult.get("ARTIST_NAME").toString().trim());
    }

    @Test
    public void testWithMixedDirectiveUse2() throws Exception {
        String sql = "SELECT #result('ARTIST_ID' 'java.lang.Integer'), ARTIST_NAME  FROM ARTIST";
        Map<String, Object> artist = this.insertArtist();
        Map<String, Object> selectResult = this.selectForQuery(sql);
        Assert.assertEquals((Object)artist.get("ARTIST_ID"), (Object)selectResult.get("ARTIST_ID"));
        Assert.assertEquals((Object)artist.get("ARTIST_NAME"), (Object)selectResult.get("ARTIST_NAME"));
    }

    private Map<String, Object> selectForQuery(String sql) {
        SQLTemplate template = new SQLTemplate(Artist.class, sql);
        template.setColumnNamesCapitalization(CapsStrategy.UPPER);
        MockOperationObserver observer = new MockOperationObserver();
        this.runtime.getDataDomain().performQueries(Collections.singletonList(template), observer);
        List data = observer.rowsForQuery(template);
        Assert.assertEquals((long)1L, (long)data.size());
        Map row = (Map)data.get(0);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> insertArtist() throws Exception {
        MockOperationObserver observer;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", 1);
        parameters.put("name", "ArtistToTestResult");
        String templateString = "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) VALUES (#bind($id), #bind($name), #bind($dob))";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        template.setParams(parameters);
        SQLTemplateAction action = new SQLTemplateAction(template, this.node);
        Connection c = this.runtime.getDataDomain().getDataNodes().iterator().next().getDataSource().getConnection();
        try {
            observer = new MockOperationObserver();
            action.performAction(c, observer);
            int[] batches = observer.countsForQuery(template);
            Assert.assertNotNull((Object)batches);
            Assert.assertEquals((long)1L, (long)batches.length);
            Assert.assertEquals((long)1L, (long)batches[0]);
        }
        finally {
            c.close();
        }
        observer = new MockOperationObserver();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        this.runtime.getDataDomain().performQueries(Collections.singletonList(query), observer);
        List data = observer.rowsForQuery(query);
        Assert.assertEquals((long)1L, (long)data.size());
        DataRow row = (DataRow)data.get(0);
        return row;
    }
}

