/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.velocity;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.access.jdbc.ParameterBinding;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.util.ConversionUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class BindDirective
extends Directive {
    public String getName() {
        return "bind";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        String typeString;
        Object value = this.getChild(context, node, 0);
        Object type = this.getChild(context, node, 1);
        int scale = ConversionUtil.toInt(this.getChild(context, node, 2), -1);
        String string = typeString = type != null ? type.toString() : null;
        if (value instanceof Collection) {
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                this.render(context, writer, node, it.next(), typeString, scale);
                if (!it.hasNext()) continue;
                writer.write(44);
            }
        } else {
            this.render(context, writer, node, value, typeString, scale);
        }
        return true;
    }

    protected void render(InternalContextAdapter context, Writer writer, Node node, Object value, String typeString, int scale) throws IOException, ParseErrorException {
        int jdbcType = Integer.MAX_VALUE;
        jdbcType = typeString != null ? TypesMapping.getSqlTypeByName(typeString) : (value != null ? TypesMapping.getSqlTypeByJava(value.getClass()) : TypesMapping.getSqlTypeByName("NULL"));
        if (jdbcType == Integer.MAX_VALUE) {
            throw new ParseErrorException("Can't determine JDBC type of binding (" + value + ", " + typeString + ") at line " + node.getLine() + ", column " + node.getColumn());
        }
        this.render(context, writer, new ParameterBinding(value, jdbcType, scale));
    }

    protected void render(InternalContextAdapter context, Writer writer, ParameterBinding binding) throws IOException {
        this.bind(context, binding);
        writer.write(63);
    }

    protected Object getChild(InternalContextAdapter context, Node node, int i) throws MethodInvocationException {
        return i >= 0 && i < node.jjtGetNumChildren() ? node.jjtGetChild(i).value(context) : null;
    }

    protected void bind(InternalContextAdapter context, ParameterBinding binding) {
        Collection bindings = (Collection)context.getInternalUserContext().get("bindings");
        if (bindings != null) {
            bindings.add(binding);
        }
    }
}

