/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.DefaultTransactionManager;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionalOperation;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DefaultTransactionManagerIT
extends ServerCase {
    @Test
    public void testPerformInTransaction_NoTx() {
        BaseTransaction tx = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        TransactionFactory txFactory = (TransactionFactory)Mockito.mock(TransactionFactory.class);
        Mockito.when((Object)txFactory.createTransaction()).thenReturn((Object)tx);
        DefaultTransactionManager txManager = new DefaultTransactionManager(txFactory, (JdbcEventLogger)Mockito.mock(JdbcEventLogger.class));
        final Object expectedResult = new Object();
        Object result = txManager.performInTransaction(new TransactionalOperation<Object>(){

            @Override
            public Object perform() {
                Assert.assertNotNull((Object)BaseTransaction.getThreadTransaction());
                return expectedResult;
            }
        });
        Assert.assertSame((Object)expectedResult, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerformInTransaction_ExistingTx() {
        BaseTransaction tx1 = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        TransactionFactory txFactory = (TransactionFactory)Mockito.mock(TransactionFactory.class);
        Mockito.when((Object)txFactory.createTransaction()).thenReturn((Object)tx1);
        DefaultTransactionManager txManager = new DefaultTransactionManager(txFactory, (JdbcEventLogger)Mockito.mock(JdbcEventLogger.class));
        final BaseTransaction tx2 = (BaseTransaction)Mockito.mock(BaseTransaction.class);
        BaseTransaction.bindThreadTransaction(tx2);
        try {
            final Object expectedResult = new Object();
            Object result = txManager.performInTransaction(new TransactionalOperation<Object>(){

                @Override
                public Object perform() {
                    Assert.assertSame((Object)tx2, (Object)BaseTransaction.getThreadTransaction());
                    return expectedResult;
                }
            });
            Assert.assertSame((Object)expectedResult, (Object)result);
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
        }
    }
}

