/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.query.NamedQuery;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class NamedQueryTest {
    @Test
    public void testName() {
        NamedQuery query = new NamedQuery("abc");
        Assert.assertEquals((Object)"abc", (Object)query.getName());
        query.setName("123");
        Assert.assertEquals((Object)"123", (Object)query.getName());
    }

    @Test
    public void testQueryName() {
        NamedQuery query = new NamedQuery("abc");
        Assert.assertEquals((Object)"abc", (Object)query.getName());
    }

    @Test
    public void testSerializability() throws Exception {
        NamedQuery o = new NamedQuery("abc");
        NamedQuery clone = Util.cloneViaSerialization(o);
        Assert.assertTrue((boolean)(clone instanceof NamedQuery));
        NamedQuery c1 = clone;
        Assert.assertNotSame((Object)o, (Object)c1);
        Assert.assertEquals((Object)o.getName(), (Object)c1.getName());
    }

    @Test
    public void testEquals() throws Exception {
        NamedQuery q1 = new NamedQuery("abc", new String[]{"a", "b"}, new Object[]{"1", "2"});
        NamedQuery q2 = new NamedQuery("abc", new String[]{"a", "b"}, new Object[]{"1", "2"});
        NamedQuery q3 = new NamedQuery("abc", new String[]{"a", "b"}, new Object[]{"1", "3"});
        NamedQuery q4 = new NamedQuery("123", new String[]{"a", "b"}, new Object[]{"1", "2"});
        Assert.assertTrue((boolean)q1.equals(q2));
        Assert.assertEquals((long)q1.hashCode(), (long)q2.hashCode());
        Assert.assertFalse((boolean)q1.equals(q3));
        Assert.assertFalse((q1.hashCode() == q3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)q1.equals(q4));
        Assert.assertFalse((q1.hashCode() == q4.hashCode() ? 1 : 0) != 0);
    }
}

