/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collection;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.AddColumnToDb;
import org.apache.cayenne.merge.AddColumnToModel;
import org.apache.cayenne.merge.AddRelationshipToDb;
import org.apache.cayenne.merge.AddRelationshipToModel;
import org.apache.cayenne.merge.CreateTableToDb;
import org.apache.cayenne.merge.CreateTableToModel;
import org.apache.cayenne.merge.DropColumnToDb;
import org.apache.cayenne.merge.DropColumnToModel;
import org.apache.cayenne.merge.DropRelationshipToDb;
import org.apache.cayenne.merge.DropRelationshipToModel;
import org.apache.cayenne.merge.DropTableToDb;
import org.apache.cayenne.merge.DropTableToModel;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.SetAllowNullToDb;
import org.apache.cayenne.merge.SetAllowNullToModel;
import org.apache.cayenne.merge.SetColumnTypeToDb;
import org.apache.cayenne.merge.SetColumnTypeToModel;
import org.apache.cayenne.merge.SetNotNullToDb;
import org.apache.cayenne.merge.SetNotNullToModel;
import org.apache.cayenne.merge.SetPrimaryKeyToDb;
import org.apache.cayenne.merge.SetPrimaryKeyToModel;
import org.apache.cayenne.merge.SetValueForNullToDb;
import org.apache.cayenne.merge.ValueForNullProvider;

public class MergerFactory {
    public MergerToken createCreateTableToModel(DbEntity entity) {
        return new CreateTableToModel(entity);
    }

    public MergerToken createCreateTableToDb(DbEntity entity) {
        return new CreateTableToDb(entity);
    }

    public MergerToken createDropTableToModel(DbEntity entity) {
        return new DropTableToModel(entity);
    }

    public MergerToken createDropTableToDb(DbEntity entity) {
        return new DropTableToDb(entity);
    }

    public MergerToken createAddColumnToModel(DbEntity entity, DbAttribute column) {
        return new AddColumnToModel(entity, column);
    }

    public MergerToken createAddColumnToDb(DbEntity entity, DbAttribute column) {
        return new AddColumnToDb(entity, column);
    }

    public MergerToken createDropColumnToModel(DbEntity entity, DbAttribute column) {
        return new DropColumnToModel(entity, column);
    }

    public MergerToken createDropColumnToDb(DbEntity entity, DbAttribute column) {
        return new DropColumnToDb(entity, column);
    }

    public MergerToken createSetNotNullToModel(DbEntity entity, DbAttribute column) {
        return new SetNotNullToModel(entity, column);
    }

    public MergerToken createSetNotNullToDb(DbEntity entity, DbAttribute column) {
        return new SetNotNullToDb(entity, column);
    }

    public MergerToken createSetAllowNullToModel(DbEntity entity, DbAttribute column) {
        return new SetAllowNullToModel(entity, column);
    }

    public MergerToken createSetAllowNullToDb(DbEntity entity, DbAttribute column) {
        return new SetAllowNullToDb(entity, column);
    }

    public MergerToken createSetValueForNullToDb(DbEntity entity, DbAttribute column, ValueForNullProvider valueForNullProvider) {
        return new SetValueForNullToDb(entity, column, valueForNullProvider);
    }

    public MergerToken createSetColumnTypeToModel(DbEntity entity, DbAttribute columnOriginal, DbAttribute columnNew) {
        return new SetColumnTypeToModel(entity, columnOriginal, columnNew);
    }

    public MergerToken createSetColumnTypeToDb(DbEntity entity, DbAttribute columnOriginal, DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew);
    }

    public MergerToken createAddRelationshipToDb(DbEntity entity, DbRelationship rel) {
        return new AddRelationshipToDb(entity, rel);
    }

    public MergerToken createAddRelationshipToModel(DbEntity entity, DbRelationship rel) {
        return new AddRelationshipToModel(entity, rel);
    }

    public MergerToken createDropRelationshipToDb(DbEntity entity, DbRelationship rel) {
        return new DropRelationshipToDb(entity, rel);
    }

    public MergerToken createDropRelationshipToModel(DbEntity entity, DbRelationship rel) {
        return new DropRelationshipToModel(entity, rel);
    }

    public MergerToken createSetPrimaryKeyToDb(DbEntity entity, Collection<DbAttribute> primaryKeyOriginal, Collection<DbAttribute> primaryKeyNew, String detectedPrimaryKeyName) {
        return new SetPrimaryKeyToDb(entity, primaryKeyOriginal, primaryKeyNew, detectedPrimaryKeyName);
    }

    public MergerToken createSetPrimaryKeyToModel(DbEntity entity, Collection<DbAttribute> primaryKeyOriginal, Collection<DbAttribute> primaryKeyNew, String detectedPrimaryKeyName) {
        return new SetPrimaryKeyToModel(entity, primaryKeyOriginal, primaryKeyNew, detectedPrimaryKeyName);
    }
}

