/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.List;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.merge.DropColumnToModel;
import org.apache.cayenne.merge.DropRelationshipToModel;
import org.apache.cayenne.merge.MergeCase;
import org.apache.cayenne.merge.MergerToken;
import org.junit.Assert;
import org.junit.Test;

public class DropColumnToModelIT
extends MergeCase {
    @Test
    public void testSimpleColumn() throws Exception {
        this.dropTableIfPresent("NEW_TABLE");
        this.assertTokensAndExecute(0, 0);
        DbEntity dbEntity = new DbEntity("NEW_TABLE");
        DbAttribute column1 = new DbAttribute("ID", 4, dbEntity);
        column1.setMandatory(true);
        column1.setPrimaryKey(true);
        dbEntity.addAttribute(column1);
        DbAttribute column2 = new DbAttribute("NAME", 12, dbEntity);
        column2.setMaxLength(10);
        column2.setMandatory(false);
        dbEntity.addAttribute(column2);
        this.map.addDbEntity(dbEntity);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        ObjEntity objEntity = new ObjEntity("NewTable");
        objEntity.setDbEntity(dbEntity);
        ObjAttribute oatr1 = new ObjAttribute("name");
        oatr1.setDbAttributePath(column2.getName());
        oatr1.setType("java.lang.String");
        objEntity.addAttribute(oatr1);
        this.map.addObjEntity(objEntity);
        MergerToken token = this.mergerFactory().createDropColumnToDb(dbEntity, column2);
        this.execute(token);
        List<MergerToken> tokens = this.createMergeTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        token = tokens.get(0);
        if (token.getDirection().isToDb()) {
            token = token.createReverse(this.mergerFactory());
        }
        Assert.assertTrue((boolean)(token instanceof DropColumnToModel));
        this.execute(token);
        Assert.assertNull((Object)dbEntity.getAttribute(column2.getName()));
        Assert.assertNull((Object)objEntity.getAttribute(oatr1.getName()));
        this.map.removeObjEntity(objEntity.getName(), true);
        this.map.removeDbEntity(dbEntity.getName(), true);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getObjEntity(objEntity.getName()));
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity.getName()));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity));
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
    }

    @Test
    public void testRemoveFKColumnWithoutRelationshipInDb() throws Exception {
        this.dropTableIfPresent("NEW_TABLE");
        this.dropTableIfPresent("NEW_TABLE2");
        this.assertTokensAndExecute(0, 0);
        DbEntity dbEntity1 = new DbEntity("NEW_TABLE");
        DbAttribute e1col1 = new DbAttribute("ID", 4, dbEntity1);
        e1col1.setMandatory(true);
        e1col1.setPrimaryKey(true);
        dbEntity1.addAttribute(e1col1);
        DbAttribute e1col2 = new DbAttribute("NAME", 12, dbEntity1);
        e1col2.setMaxLength(10);
        e1col2.setMandatory(false);
        dbEntity1.addAttribute(e1col2);
        this.map.addDbEntity(dbEntity1);
        DbEntity dbEntity2 = new DbEntity("NEW_TABLE2");
        DbAttribute e2col1 = new DbAttribute("ID", 4, dbEntity2);
        e2col1.setMandatory(true);
        e2col1.setPrimaryKey(true);
        dbEntity2.addAttribute(e2col1);
        DbAttribute e2col2 = new DbAttribute("FK", 4, dbEntity2);
        dbEntity2.addAttribute(e2col2);
        DbAttribute e2col3 = new DbAttribute("NAME", 12, dbEntity2);
        e2col3.setMaxLength(10);
        dbEntity2.addAttribute(e2col3);
        this.map.addDbEntity(dbEntity2);
        this.assertTokensAndExecute(2, 0);
        this.assertTokensAndExecute(0, 0);
        this.execute(this.mergerFactory().createDropColumnToDb(dbEntity2, e2col2));
        DbRelationship rel1To2 = new DbRelationship("rel1To2");
        rel1To2.setSourceEntity(dbEntity1);
        rel1To2.setTargetEntityName(dbEntity2);
        rel1To2.setToMany(true);
        rel1To2.addJoin(new DbJoin(rel1To2, e1col1.getName(), e2col2.getName()));
        dbEntity1.addRelationship(rel1To2);
        DbRelationship rel2To1 = new DbRelationship("rel2To1");
        rel2To1.setSourceEntity(dbEntity2);
        rel2To1.setTargetEntityName(dbEntity1);
        rel2To1.setToMany(false);
        rel2To1.addJoin(new DbJoin(rel2To1, e2col2.getName(), e1col1.getName()));
        dbEntity2.addRelationship(rel2To1);
        Assert.assertSame((Object)rel1To2, (Object)rel2To1.getReverseRelationship());
        Assert.assertSame((Object)rel2To1, (Object)rel1To2.getReverseRelationship());
        ObjEntity objEntity1 = new ObjEntity("NewTable");
        objEntity1.setDbEntity(dbEntity1);
        ObjAttribute oatr1 = new ObjAttribute("name");
        oatr1.setDbAttributePath(e1col2.getName());
        oatr1.setType("java.lang.String");
        objEntity1.addAttribute(oatr1);
        this.map.addObjEntity(objEntity1);
        ObjEntity objEntity2 = new ObjEntity("NewTable2");
        objEntity2.setDbEntity(dbEntity2);
        ObjAttribute o2a1 = new ObjAttribute("name");
        o2a1.setDbAttributePath(e2col3.getName());
        o2a1.setType("java.lang.String");
        objEntity2.addAttribute(o2a1);
        this.map.addObjEntity(objEntity2);
        Assert.assertEquals((long)0L, (long)objEntity1.getRelationships().size());
        Assert.assertEquals((long)0L, (long)objEntity2.getRelationships().size());
        ObjRelationship objRel1To2 = new ObjRelationship("objRel1To2");
        objRel1To2.addDbRelationship(rel1To2);
        objRel1To2.setSourceEntity(objEntity1);
        objRel1To2.setTargetEntityName(objEntity2);
        objEntity1.addRelationship(objRel1To2);
        ObjRelationship objRel2To1 = new ObjRelationship("objRel2To1");
        objRel2To1.addDbRelationship(rel2To1);
        objRel2To1.setSourceEntity(objEntity2);
        objRel2To1.setTargetEntityName(objEntity1);
        objEntity2.addRelationship(objRel2To1);
        Assert.assertEquals((long)1L, (long)objEntity1.getRelationships().size());
        Assert.assertEquals((long)1L, (long)objEntity2.getRelationships().size());
        Assert.assertSame((Object)objRel1To2, (Object)objRel2To1.getReverseRelationship());
        Assert.assertSame((Object)objRel2To1, (Object)objRel1To2.getReverseRelationship());
        List<MergerToken> tokens = this.createMergeTokens();
        this.assertTokens(tokens, 2, 0);
        MergerToken token0 = tokens.get(0).createReverse(this.mergerFactory());
        MergerToken token1 = tokens.get(1).createReverse(this.mergerFactory());
        if (!(token0 instanceof DropRelationshipToModel && token1 instanceof DropColumnToModel || token1 instanceof DropRelationshipToModel && token0 instanceof DropColumnToModel)) {
            Assert.fail();
        }
        if (token1 instanceof DropColumnToModel) {
            this.execute(token1);
        } else {
            this.execute(token0);
        }
        Assert.assertNull((Object)dbEntity2.getAttribute(e2col2.getName()));
        Assert.assertEquals((long)0L, (long)dbEntity1.getRelationships().size());
        Assert.assertEquals((long)0L, (long)dbEntity2.getRelationships().size());
        Assert.assertEquals((long)0L, (long)objEntity1.getRelationships().size());
        Assert.assertEquals((long)0L, (long)objEntity2.getRelationships().size());
        dbEntity1.removeRelationship(rel1To2.getName());
        dbEntity2.removeRelationship(rel2To1.getName());
        this.map.removeObjEntity(objEntity1.getName(), true);
        this.map.removeDbEntity(dbEntity1.getName(), true);
        this.map.removeObjEntity(objEntity2.getName(), true);
        this.map.removeDbEntity(dbEntity2.getName(), true);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getObjEntity(objEntity1.getName()));
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity1.getName()));
        Assert.assertNull((Object)this.map.getObjEntity(objEntity2.getName()));
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity2.getName()));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity1));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity2));
        this.assertTokensAndExecute(2, 0);
        this.assertTokensAndExecute(0, 0);
    }
}

