/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map.naming;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.naming.ExportedKey;
import org.apache.cayenne.map.naming.LegacyNameGenerator;
import org.junit.Assert;
import org.junit.Test;

public class LegacyNameGeneratorTest {
    @Test
    public void testStrategy() throws Exception {
        LegacyNameGenerator strategy = new LegacyNameGenerator();
        ExportedKey key = new ExportedKey("ARTIST", "ARTIST_ID", null, "PAINTING", "ARTIST_ID", null, 1);
        Assert.assertEquals((Object)strategy.createDbRelationshipName(key, false), (Object)"toArtist");
        Assert.assertEquals((Object)strategy.createDbRelationshipName(key, true), (Object)"paintingArray");
        key = new ExportedKey("PERSON", "PERSON_ID", null, "PERSON", "MOTHER_ID", null, 1);
        Assert.assertEquals((Object)strategy.createDbRelationshipName(key, false), (Object)"toPerson");
        Assert.assertEquals((Object)strategy.createDbRelationshipName(key, true), (Object)"personArray");
        Assert.assertEquals((Object)strategy.createObjEntityName(new DbEntity("ARTIST")), (Object)"Artist");
        Assert.assertEquals((Object)strategy.createObjEntityName(new DbEntity("ARTIST_WORK")), (Object)"ArtistWork");
        Assert.assertEquals((Object)strategy.createObjAttributeName(new DbAttribute("NAME")), (Object)"name");
        Assert.assertEquals((Object)strategy.createObjAttributeName(new DbAttribute("ARTIST_NAME")), (Object)"artistName");
        Assert.assertEquals((Object)strategy.createObjRelationshipName(new DbRelationship("toArtist")), (Object)"toArtist");
        Assert.assertEquals((Object)strategy.createObjRelationshipName(new DbRelationship("paintingArray")), (Object)"paintingArray");
    }
}

