/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Collection;
import java.util.HashMap;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjEntityIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testGetAttributeWithOverrides() {
        DataMap map = new DataMap("dm");
        ObjEntity superEntity = new ObjEntity("super");
        superEntity.addAttribute(new ObjAttribute("a1", "int", superEntity));
        superEntity.addAttribute(new ObjAttribute("a2", "int", superEntity));
        map.addObjEntity(superEntity);
        ObjEntity subEntity = new ObjEntity("sub");
        subEntity.setSuperEntityName(superEntity.getName());
        subEntity.addAttributeOverride("a1", "overridden.path");
        subEntity.addAttribute(new ObjAttribute("a3", "int", subEntity));
        map.addObjEntity(subEntity);
        ObjAttribute a1 = subEntity.getAttribute("a1");
        Assert.assertNotNull((Object)a1);
        Assert.assertSame((Object)subEntity, (Object)a1.getEntity());
        Assert.assertEquals((Object)"overridden.path", (Object)a1.getDbAttributePath());
        Assert.assertEquals((Object)"int", (Object)a1.getType());
        ObjAttribute a2 = subEntity.getAttribute("a2");
        Assert.assertNotNull((Object)a2);
        Assert.assertSame((Object)subEntity, (Object)a2.getEntity());
        Assert.assertNull((Object)a2.getDbAttributePath());
        ObjAttribute a3 = subEntity.getAttribute("a3");
        Assert.assertNotNull((Object)a3);
        Assert.assertSame((Object)subEntity, (Object)a3.getEntity());
    }

    @Test
    public void testGetPrimaryKeys() {
        ObjEntity artistE = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        Collection<ObjAttribute> pks = artistE.getPrimaryKeys();
        Assert.assertEquals((long)1L, (long)pks.size());
        ObjAttribute pk = pks.iterator().next();
        Assert.assertEquals((Object)"java.lang.Long", (Object)pk.getType());
        Assert.assertEquals((Object)"ARTIST_ID", (Object)pk.getDbAttributePath());
        Assert.assertEquals((Object)"artistId", (Object)pk.getName());
        Assert.assertNull((Object)pk.getEntity());
        Assert.assertFalse((boolean)artistE.getAttributes().contains(pk));
        ObjEntity clientArtistE = artistE.getClientEntity();
        Collection<ObjAttribute> clientpks = clientArtistE.getPrimaryKeys();
        Assert.assertEquals((long)1L, (long)clientpks.size());
        ObjAttribute clientPk = clientpks.iterator().next();
        Assert.assertEquals((Object)"java.lang.Long", (Object)clientPk.getType());
        Assert.assertEquals((Object)"ARTIST_ID", (Object)clientPk.getDbAttributePath());
        Assert.assertEquals((Object)"artistId", (Object)clientPk.getName());
        Assert.assertNull((Object)clientPk.getEntity());
        Assert.assertFalse((boolean)clientArtistE.getAttributes().contains(pk));
        ObjEntity meaningfulPKE = this.runtime.getDataDomain().getEntityResolver().getObjEntity("MeaningfulGeneratedColumnTestEntity");
        Collection<ObjAttribute> mpks = meaningfulPKE.getPrimaryKeys();
        Assert.assertEquals((long)1L, (long)mpks.size());
        ObjAttribute mpk = mpks.iterator().next();
        Assert.assertTrue((boolean)meaningfulPKE.getAttributes().contains(mpk));
        ObjEntity clientMeaningfulPKE = meaningfulPKE.getClientEntity();
        Collection<ObjAttribute> clientmpks = clientMeaningfulPKE.getPrimaryKeys();
        Assert.assertEquals((long)1L, (long)clientmpks.size());
        ObjAttribute clientmpk = clientmpks.iterator().next();
        Assert.assertEquals((Object)"java.lang.Integer", (Object)clientmpk.getType());
        Assert.assertTrue((boolean)clientMeaningfulPKE.getAttributes().contains(clientmpk));
    }

    @Test
    public void testAttributes() {
        ObjEntity artistE = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        ObjAttribute attr = artistE.getAttribute("artistName");
        Assert.assertEquals((long)attr.getMaxLength(), (long)attr.getDbAttribute().getMaxLength());
        Assert.assertEquals((Object)attr.isMandatory(), (Object)attr.getDbAttribute().isMandatory());
    }

    @Test
    public void testLastPathComponent() {
        ObjEntity artistE = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("a", "paintingArray.toGallery");
        PathComponent<ObjAttribute, ObjRelationship> lastAttribute = artistE.lastPathComponent(Expression.fromString("paintingArray.paintingTitle"), aliases);
        Assert.assertTrue((lastAttribute.getAttribute() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"paintingTitle", (Object)lastAttribute.getAttribute().getName());
        PathComponent<ObjAttribute, ObjRelationship> lastRelationship = artistE.lastPathComponent(Expression.fromString("paintingArray.toGallery"), aliases);
        Assert.assertTrue((lastRelationship.getRelationship() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"toGallery", (Object)lastRelationship.getRelationship().getName());
        PathComponent<ObjAttribute, ObjRelationship> lastLeftJoinRelationship = artistE.lastPathComponent(new ASTObjPath("paintingArray+.toGallery+"), aliases);
        Assert.assertTrue((lastLeftJoinRelationship.getRelationship() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"toGallery", (Object)lastLeftJoinRelationship.getRelationship().getName());
        PathComponent<ObjAttribute, ObjRelationship> lastAliasedRelationship = artistE.lastPathComponent(new ASTObjPath("a"), aliases);
        Assert.assertTrue((lastAliasedRelationship.getRelationship() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"toGallery", (Object)lastAliasedRelationship.getRelationship().getName());
    }

    @Test
    public void testGeneric() {
        ObjEntity e1 = new ObjEntity("e1");
        Assert.assertTrue((boolean)e1.isGeneric());
        e1.setClassName("SomeClass");
        Assert.assertFalse((boolean)e1.isGeneric());
        DataMap m = new DataMap("X");
        m.setDefaultSuperclass("SomeClass");
        m.addObjEntity(e1);
        Assert.assertTrue((boolean)e1.isGeneric());
        e1.setClassName("SomeOtherClass");
        Assert.assertFalse((boolean)e1.isGeneric());
        e1.setClassName(CayenneDataObject.class.getName());
        Assert.assertTrue((boolean)e1.isGeneric());
    }

    @Test
    public void testServerOnly() {
        ObjEntity e1 = new ObjEntity("e1");
        Assert.assertFalse((boolean)e1.isServerOnly());
        e1.setServerOnly(true);
        Assert.assertTrue((boolean)e1.isServerOnly());
    }

    @Test
    public void testClientAllowed() {
        ObjEntity e1 = new ObjEntity("e1");
        Assert.assertFalse((String)"No parent DataMap should have automatically disabled client.", (boolean)e1.isClientAllowed());
        DataMap map = new DataMap("m1");
        e1.setDataMap(map);
        Assert.assertFalse((boolean)e1.isClientAllowed());
        map.setClientSupported(true);
        Assert.assertTrue((boolean)e1.isClientAllowed());
        e1.setServerOnly(true);
        Assert.assertFalse((boolean)e1.isClientAllowed());
    }

    @Test
    public void testGetPrimaryKeyNames() {
        ObjEntity entity = new ObjEntity("entity");
        DbEntity dbentity = new DbEntity("dbe");
        DataMap dataMap = new DataMap();
        dataMap.addObjEntity(entity);
        dataMap.addDbEntity(dbentity);
        entity.setDbEntity(dbentity);
        Assert.assertEquals((long)0L, (long)entity.getPrimaryKeyNames().size());
        DbAttribute pk = new DbAttribute();
        pk.setName("id");
        pk.setPrimaryKey(true);
        dbentity.addAttribute(pk);
        Assert.assertEquals((long)1L, (long)entity.getPrimaryKeyNames().size());
        Assert.assertTrue((boolean)entity.getPrimaryKeyNames().contains(pk.getName()));
        DbAttribute pk2 = new DbAttribute();
        pk2.setName("id2");
        pk2.setPrimaryKey(true);
        dbentity.addAttribute(pk2);
        Assert.assertEquals((long)2L, (long)entity.getPrimaryKeyNames().size());
        Assert.assertTrue((boolean)entity.getPrimaryKeyNames().contains(pk.getName()));
        Assert.assertTrue((boolean)entity.getPrimaryKeyNames().contains(pk2.getName()));
    }

    @Test
    public void testGetClientEntity() {
        DataMap map = new DataMap();
        map.setClientSupported(true);
        final ObjEntity target = new ObjEntity("te1");
        map.addObjEntity(target);
        ObjEntity e1 = new ObjEntity("entity");
        e1.setClassName("x.y.z");
        e1.setClientClassName("a.b.c");
        e1.addAttribute(new ObjAttribute("A1"));
        e1.addAttribute(new ObjAttribute("A2"));
        map.addObjEntity(e1);
        DbEntity dbentity = new DbEntity("dbe");
        map.addDbEntity(dbentity);
        e1.setDbEntity(dbentity);
        ObjRelationship r1 = new ObjRelationship("r1"){

            @Override
            public ObjEntity getTargetEntity() {
                return target;
            }
        };
        e1.addRelationship(r1);
        ObjEntity e2 = e1.getClientEntity();
        Assert.assertNotNull((Object)e2);
        Assert.assertEquals((Object)e1.getName(), (Object)e2.getName());
        Assert.assertEquals((Object)e1.getClientClassName(), (Object)e2.getClassName());
        Assert.assertEquals((long)e1.getAttributes().size(), (long)e2.getAttributes().size());
        Assert.assertEquals((long)e1.getRelationships().size(), (long)e2.getRelationships().size());
    }

    @Test
    public void testSerializability() throws Exception {
        ObjEntity entity = new ObjEntity("entity");
        ObjEntity d1 = Util.cloneViaSerialization(entity);
        Assert.assertEquals((Object)entity.getName(), (Object)d1.getName());
    }

    @Test
    public void testDbEntityName() {
        ObjEntity entity = new ObjEntity("entity");
        Assert.assertNull((Object)entity.getDbEntityName());
        entity.setDbEntityName("dbe");
        Assert.assertEquals((Object)"dbe", (Object)entity.getDbEntityName());
        entity.setDbEntityName(null);
        Assert.assertNull((Object)entity.getDbEntityName());
    }

    @Test
    public void testDbEntity() {
        ObjEntity entity = new ObjEntity("entity");
        DbEntity dbentity = new DbEntity("dbe");
        DataMap dataMap = new DataMap();
        dataMap.addObjEntity(entity);
        dataMap.addDbEntity(dbentity);
        Assert.assertNull((Object)entity.getDbEntity());
        entity.setDbEntity(dbentity);
        Assert.assertSame((Object)dbentity, (Object)entity.getDbEntity());
        entity.setDbEntity(null);
        Assert.assertNull((Object)entity.getDbEntity());
        entity.setDbEntityName("dbe");
        Assert.assertSame((Object)dbentity, (Object)entity.getDbEntity());
    }

    @Test
    public void testDbEntityNoContainer() {
        ObjEntity entity = new ObjEntity("entity");
        entity.setDbEntityName("dbe");
        try {
            entity.getDbEntity();
            Assert.fail((String)"Without a container ObjENtity shouldn't resolve DbEntity");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testClassName() {
        ObjEntity entity = new ObjEntity("entity");
        String tstName = "tst_name";
        entity.setClassName(tstName);
        Assert.assertEquals((Object)tstName, (Object)entity.getClassName());
    }

    @Test
    public void testSuperClassName() {
        ObjEntity entity = new ObjEntity("entity");
        String tstName = "super_tst_name";
        entity.setSuperClassName(tstName);
        Assert.assertEquals((Object)tstName, (Object)entity.getSuperClassName());
    }

    @Test
    public void testAttributeForDbAttribute() throws Exception {
        ObjEntity ae = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        DbEntity dae = ae.getDbEntity();
        Assert.assertNull((Object)ae.getAttributeForDbAttribute(dae.getAttribute("ARTIST_ID")));
        Assert.assertNotNull((Object)ae.getAttributeForDbAttribute(dae.getAttribute("ARTIST_NAME")));
    }

    @Test
    public void testRelationshipForDbRelationship() throws Exception {
        ObjEntity ae = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        DbEntity dae = ae.getDbEntity();
        Assert.assertNull((Object)ae.getRelationshipForDbRelationship(new DbRelationship()));
        Assert.assertNotNull((Object)ae.getRelationshipForDbRelationship(dae.getRelationship("paintingArray")));
    }

    @Test
    public void testReadOnly() throws Exception {
        ObjEntity entity = new ObjEntity("entity");
        Assert.assertFalse((boolean)entity.isReadOnly());
        entity.setReadOnly(true);
        Assert.assertTrue((boolean)entity.isReadOnly());
    }

    @Test
    public void testTranslateToRelatedEntityIndependentPath() throws Exception {
        ObjEntity artistE = this.runtime.getDataDomain().getEntityResolver().getObjEntity(Artist.class);
        Expression e1 = Expression.fromString("paintingArray");
        Expression translated = artistE.translateToRelatedEntity(e1, "artistExhibitArray");
        Assert.assertEquals((String)("failure: " + translated), (Object)Expression.fromString("db:toArtist.paintingArray"), (Object)translated);
    }

    @Test
    public void testTranslateToRelatedEntityTrimmedPath() throws Exception {
        ObjEntity artistE = this.runtime.getDataDomain().getEntityResolver().getObjEntity(Artist.class);
        Expression e1 = Expression.fromString("artistExhibitArray.toExhibit");
        Expression translated = artistE.translateToRelatedEntity(e1, "artistExhibitArray");
        Assert.assertEquals((String)("failure: " + translated), (Object)Expression.fromString("db:toArtist.artistExhibitArray.toExhibit"), (Object)translated);
    }

    @Test
    public void testTranslateToRelatedEntitySplitHalfWay() throws Exception {
        ObjEntity artistE = this.runtime.getDataDomain().getEntityResolver().getObjEntity(Artist.class);
        Expression e1 = Expression.fromString("paintingArray.toPaintingInfo.textReview");
        Expression translated = artistE.translateToRelatedEntity(e1, "paintingArray.toGallery");
        Assert.assertEquals((String)("failure: " + translated), (Object)Expression.fromString("db:paintingArray.toArtist.paintingArray.toPaintingInfo.TEXT_REVIEW"), (Object)translated);
    }

    @Test
    public void testTranslateToRelatedEntityMatchingPath() throws Exception {
        ObjEntity artistE = this.runtime.getDataDomain().getEntityResolver().getObjEntity(Artist.class);
        Expression e1 = Expression.fromString("artistExhibitArray.toExhibit");
        Expression translated = artistE.translateToRelatedEntity(e1, "artistExhibitArray.toExhibit");
        Assert.assertEquals((String)("failure: " + translated), (Object)Expression.fromString("db:artistExhibitArray.toArtist.artistExhibitArray.toExhibit"), (Object)translated);
    }

    @Test
    public void testTranslateToRelatedEntityMultiplePaths() throws Exception {
        ObjEntity artistE = this.runtime.getDataDomain().getEntityResolver().getObjEntity(Artist.class);
        Expression e1 = Expression.fromString("paintingArray = $p and artistExhibitArray.toExhibit.closingDate = $d");
        Expression translated = artistE.translateToRelatedEntity(e1, "artistExhibitArray");
        Assert.assertEquals((String)("failure: " + translated), (Object)Expression.fromString("db:toArtist.paintingArray = $p and db:toArtist.artistExhibitArray.toExhibit.CLOSING_DATE = $d"), (Object)translated);
    }

    @Test
    public void testTranslateToRelatedEntityOuterJoin_Flattened() throws Exception {
        ObjEntity artistE = this.runtime.getDataDomain().getEntityResolver().getObjEntity(Artist.class);
        Expression e1 = Expression.fromString("groupArray+.name");
        Expression translated = artistE.translateToRelatedEntity(e1, "artistExhibitArray");
        Assert.assertEquals((String)("failure: " + translated), (Object)Expression.fromString("db:toArtist.artistGroupArray+.toGroup+.NAME"), (Object)translated);
    }

    @Test
    public void testTranslateNullArg() {
        ObjEntity entity = this.context.getEntityResolver().getObjEntity("Artist");
        Expression exp = ExpressionFactory.noMatchExp("dateOfBirth", null);
        Expression translated = entity.translateToDbPath(exp);
        Assert.assertFalse((boolean)translated.match(new Artist()));
    }
}

