/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.parser.Evaluator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class EvaluatorTest {
    @Test
    public void testEvaluator_Null() {
        Evaluator e = Evaluator.evaluator(null);
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.eq(null, null));
        Assert.assertFalse((boolean)e.eq(null, new Object()));
    }

    @Test
    public void testEvaluator_Object() {
        Object o = new Object();
        Evaluator e = Evaluator.evaluator(o);
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.eq(o, o));
        Assert.assertFalse((boolean)e.eq(o, null));
    }

    @Test
    public void testEvaluator_Number() {
        Evaluator e = Evaluator.evaluator(1);
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.eq(1, 1));
        Assert.assertFalse((boolean)e.eq(1, null));
        Assert.assertFalse((boolean)e.eq(1, 5));
        Assert.assertFalse((boolean)e.eq(1, 1.1));
    }

    @Test
    public void testEvaluator_BigDecimal() {
        BigDecimal lhs = new BigDecimal("1.10");
        Evaluator e = Evaluator.evaluator(lhs);
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.eq(lhs, new BigDecimal("1.1")));
        Assert.assertFalse((boolean)e.eq(lhs, new BigDecimal("1.10001")));
        Integer c = e.compare(lhs, new BigDecimal("1.10001"));
        Assert.assertEquals((long)-1L, (long)c.intValue());
    }

    @Test
    public void testEvaluator_Persistent() {
        ObjectId lhsId = new ObjectId("X", "k", 3);
        Persistent lhs = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)lhs.getObjectId()).thenReturn((Object)lhsId);
        Evaluator e = Evaluator.evaluator(lhs);
        Assert.assertNotNull((Object)e);
        ObjectId rhsId1 = new ObjectId("X", "k", 3);
        Persistent rhs1 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs1.getObjectId()).thenReturn((Object)rhsId1);
        Assert.assertTrue((boolean)e.eq(lhs, rhs1));
        Assert.assertTrue((boolean)e.eq(lhs, rhsId1));
        Assert.assertTrue((boolean)e.eq(lhs, 3));
        ObjectId rhsId2 = new ObjectId("X", "k", 4);
        Persistent rhs2 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs2.getObjectId()).thenReturn((Object)rhsId2);
        Assert.assertFalse((boolean)e.eq(lhs, rhs2));
        Assert.assertFalse((boolean)e.eq(lhs, rhsId2));
        Assert.assertFalse((boolean)e.eq(lhs, 4));
    }

    @Test
    public void testEvaluator_Persistent_StringId() {
        ObjectId lhsId = new ObjectId("X", "k", "A");
        Persistent lhs = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)lhs.getObjectId()).thenReturn((Object)lhsId);
        Evaluator e = Evaluator.evaluator(lhs);
        Assert.assertNotNull((Object)e);
        ObjectId rhsId1 = new ObjectId("X", "k", "A");
        Persistent rhs1 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs1.getObjectId()).thenReturn((Object)rhsId1);
        Assert.assertTrue((boolean)e.eq(lhs, rhs1));
        Assert.assertTrue((boolean)e.eq(lhs, rhsId1));
        Assert.assertTrue((boolean)e.eq(lhs, "A"));
        ObjectId rhsId2 = new ObjectId("X", "k", "B");
        Persistent rhs2 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs2.getObjectId()).thenReturn((Object)rhsId2);
        Assert.assertFalse((boolean)e.eq(lhs, rhs2));
        Assert.assertFalse((boolean)e.eq(lhs, rhsId2));
        Assert.assertFalse((boolean)e.eq(lhs, "B"));
    }

    @Test
    public void testEvaluator_Persistent_MultiKey() {
        HashMap<String, Object> lhsIdMap = new HashMap<String, Object>();
        lhsIdMap.put("a", 1);
        lhsIdMap.put("b", "B");
        ObjectId lhsId = new ObjectId("X", lhsIdMap);
        Persistent lhs = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)lhs.getObjectId()).thenReturn((Object)lhsId);
        Evaluator e = Evaluator.evaluator(lhs);
        Assert.assertNotNull((Object)e);
        HashMap<String, Object> rhsId1Map = new HashMap<String, Object>();
        rhsId1Map.put("a", 1);
        rhsId1Map.put("b", "B");
        ObjectId rhsId1 = new ObjectId("X", rhsId1Map);
        Persistent rhs1 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs1.getObjectId()).thenReturn((Object)rhsId1);
        Assert.assertTrue((boolean)e.eq(lhs, rhs1));
        Assert.assertTrue((boolean)e.eq(lhs, rhsId1));
        Assert.assertTrue((boolean)e.eq(lhs, rhsId1Map));
        HashMap<String, Object> rhsId2Map = new HashMap<String, Object>();
        rhsId2Map.put("a", 1);
        rhsId2Map.put("b", "BX");
        ObjectId rhsId2 = new ObjectId("X", rhsId2Map);
        Persistent rhs2 = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)rhs2.getObjectId()).thenReturn((Object)rhsId2);
        Assert.assertFalse((boolean)e.eq(lhs, rhs2));
        Assert.assertFalse((boolean)e.eq(lhs, rhsId2));
        Assert.assertFalse((boolean)e.eq(lhs, rhsId2Map));
        Assert.assertFalse((boolean)e.eq(lhs, "B"));
    }
}

