/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ExpressionParserTreeConstants;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.util.ConversionUtil;

public class ASTNegate
extends SimpleNode {
    ASTNegate(int id) {
        super(id);
    }

    public ASTNegate() {
        super(32);
    }

    public ASTNegate(Object node) {
        super(32);
        this.jjtAddChild(this.wrapChild(node), 0);
        this.connectChildren();
    }

    @Override
    public Expression shallowCopy() {
        return new ASTNegate(this.id);
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        int len = this.jjtGetNumChildren();
        if (len == 0) {
            return null;
        }
        BigDecimal result = ConversionUtil.toBigDecimal(this.evaluateChild(0, o));
        return result != null ? result.negate() : null;
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        if (this.children != null && this.children.length > 0) {
            boolean useParen;
            out.append("-");
            SimpleNode child = (SimpleNode)this.children[0];
            boolean bl = useParen = this.parent != null && !(child instanceof ASTScalar) && !(child instanceof ASTPath);
            if (useParen) {
                out.append("(");
            }
            child.appendAsString(out);
            if (useParen) {
                out.append(')');
            }
        }
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        if (this.children != null && this.children.length > 0) {
            boolean useParen;
            out.append("-");
            SimpleNode child = (SimpleNode)this.children[0];
            boolean bl = useParen = this.parent != null && !(child instanceof ASTScalar) && !(child instanceof ASTPath);
            if (useParen) {
                out.append("(");
            }
            child.appendAsEJBQL(parameterAccumulator, out, rootId);
            if (useParen) {
                out.append(')');
            }
        }
    }

    @Override
    protected String getExpressionOperator(int index) {
        throw new UnsupportedOperationException("No operator for '" + ExpressionParserTreeConstants.jjtNodeName[this.id] + "'");
    }

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public int getOperandCount() {
        return 1;
    }
}

