/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.exp.parser.PatternMatchNode;
import org.apache.cayenne.reflect.TstJavaBean;
import org.apache.cayenne.reflect.UnresolvablePathException;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class PropertyTest {
    @Test
    public void testIn() {
        Property<String> p = new Property<String>("x.y");
        Expression e1 = p.in("a", new String[0]);
        Assert.assertEquals((Object)"x.y in (\"a\")", (Object)e1.toString());
        Expression e2 = p.in("a", "b");
        Assert.assertEquals((Object)"x.y in (\"a\", \"b\")", (Object)e2.toString());
        Expression e3 = p.in(Arrays.asList("a", "b"));
        Assert.assertEquals((Object)"x.y in (\"a\", \"b\")", (Object)e3.toString());
    }

    @Test
    public void testGetFrom() {
        TstJavaBean bean = new TstJavaBean();
        bean.setIntField(7);
        Property INT_FIELD = new Property("intField");
        Assert.assertEquals((Object)7, INT_FIELD.getFrom(bean));
    }

    @Test
    public void testGetFromNestedProperty() {
        TstJavaBean bean = new TstJavaBean();
        TstJavaBean nestedBean = new TstJavaBean();
        nestedBean.setIntField(7);
        bean.setObjectField(nestedBean);
        Property OBJECT_FIELD_INT_FIELD = new Property("objectField.intField");
        Assert.assertEquals((Object)7, OBJECT_FIELD_INT_FIELD.getFrom(bean));
    }

    @Test
    public void testGetFromNestedNull() {
        block2: {
            TstJavaBean bean = new TstJavaBean();
            bean.setObjectField(null);
            Property OBJECT_FIELD_INT_FIELD = new Property("objectField.intField");
            try {
                OBJECT_FIELD_INT_FIELD.getFrom(bean);
                Assert.fail();
            }
            catch (Exception e) {
                Throwable rootException = Util.unwindException(e);
                if (rootException instanceof UnresolvablePathException) break block2;
                Assert.fail();
            }
        }
    }

    @Test
    public void testGetFromAll() {
        TstJavaBean bean = new TstJavaBean();
        bean.setIntField(7);
        TstJavaBean bean2 = new TstJavaBean();
        bean2.setIntField(8);
        List<TstJavaBean> beans = Arrays.asList(bean, bean2);
        Property INT_FIELD = new Property("intField");
        Assert.assertEquals(Arrays.asList(7, 8), INT_FIELD.getFromAll(beans));
    }

    @Test
    public void testSetIn() {
        TstJavaBean bean = new TstJavaBean();
        Property<Integer> INT_FIELD = new Property<Integer>("intField");
        INT_FIELD.setIn(bean, 7);
        Assert.assertEquals((long)7L, (long)bean.getIntField());
    }

    @Test
    public void testSetInNestedProperty() {
        TstJavaBean bean = new TstJavaBean();
        bean.setObjectField(new TstJavaBean());
        Property<Integer> OBJECT_FIELD_INT_FIELD = new Property<Integer>("objectField.intField");
        OBJECT_FIELD_INT_FIELD.setIn(bean, 7);
        Assert.assertEquals((long)7L, (long)((TstJavaBean)bean.getObjectField()).getIntField());
    }

    @Test
    public void testSetInNestedNull() {
        block2: {
            TstJavaBean bean = new TstJavaBean();
            bean.setObjectField(null);
            Property<Integer> OBJECT_FIELD_INT_FIELD = new Property<Integer>("objectField.intField");
            try {
                OBJECT_FIELD_INT_FIELD.setIn(bean, 7);
                Assert.fail();
            }
            catch (Exception e) {
                Throwable rootException = Util.unwindException(e);
                if (rootException instanceof UnresolvablePathException) break block2;
                Assert.fail();
            }
        }
    }

    @Test
    public void testSetInAll() {
        TstJavaBean bean = new TstJavaBean();
        TstJavaBean bean2 = new TstJavaBean();
        List<TstJavaBean> beans = Arrays.asList(bean, bean2);
        Property<Integer> INT_FIELD = new Property<Integer>("intField");
        INT_FIELD.setInAll(beans, 7);
        Assert.assertEquals((long)7L, (long)bean.getIntField());
        Assert.assertEquals((long)7L, (long)bean2.getIntField());
    }

    @Test
    public void testEquals() {
        Property INT_FIELD = new Property("intField");
        Property INT_FIELD2 = new Property("intField");
        Assert.assertTrue((INT_FIELD != INT_FIELD2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)INT_FIELD.equals(INT_FIELD2));
    }

    @Test
    public void testHashCode() {
        Property INT_FIELD = new Property("intField");
        Property INT_FIELD2 = new Property("intField");
        Property LONG_FIELD = new Property("longField");
        Assert.assertTrue((INT_FIELD.hashCode() == INT_FIELD2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((INT_FIELD.hashCode() != LONG_FIELD.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testOuter() {
        Property inner = new Property("xyz");
        Assert.assertEquals((Object)"xyz+", (Object)inner.outer().getName());
        Property inner1 = new Property("xyz.xxx");
        Assert.assertEquals((Object)"xyz.xxx+", (Object)inner1.outer().getName());
        Property outer = new Property("xyz+");
        Assert.assertEquals((Object)"xyz+", (Object)outer.outer().getName());
    }

    @Test
    public void testLike() {
        Property p = new Property("prop");
        Expression e = p.like("abc");
        Assert.assertEquals((Object)"prop like \"abc\"", (Object)e.toString());
    }

    @Test
    public void testLikeIgnoreCase() {
        Property p = new Property("prop");
        Expression e = p.likeIgnoreCase("abc");
        Assert.assertEquals((Object)"prop likeIgnoreCase \"abc\"", (Object)e.toString());
    }

    @Test
    public void testLike_NoEscape() {
        Property p = new Property("prop");
        Expression e = p.like("ab%c");
        Assert.assertEquals((Object)"prop like \"ab%c\"", (Object)e.toString());
        Assert.assertEquals((long)0L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testContains() {
        Property p = new Property("prop");
        Expression e = p.contains("abc");
        Assert.assertEquals((Object)"prop like \"%abc%\"", (Object)e.toString());
        Assert.assertEquals((long)0L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testStartsWith() {
        Property p = new Property("prop");
        Expression e = p.startsWith("abc");
        Assert.assertEquals((Object)"prop like \"abc%\"", (Object)e.toString());
        Assert.assertEquals((long)0L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testEndsWith() {
        Property p = new Property("prop");
        Expression e = p.endsWith("abc");
        Assert.assertEquals((Object)"prop like \"%abc\"", (Object)e.toString());
        Assert.assertEquals((long)0L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testContains_Escape1() {
        Property p = new Property("prop");
        Expression e = p.contains("a%bc");
        Assert.assertEquals((Object)"prop like \"%a!%bc%\"", (Object)e.toString());
        Assert.assertEquals((long)33L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testContains_Escape2() {
        Property p = new Property("prop");
        Expression e = p.contains("a_!bc");
        Assert.assertEquals((Object)"prop like \"%a#_!bc%\"", (Object)e.toString());
        Assert.assertEquals((long)35L, (long)((PatternMatchNode)e).getEscapeChar());
    }
}

