/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.ExpressionParameter;
import org.apache.cayenne.exp.TstTraversalHandler;
import org.apache.cayenne.exp.parser.ASTList;
import org.junit.Assert;
import org.junit.Test;

public class Expression_ParamsTest {
    @Test
    public void testParams_Positional1() {
        Expression e = ExpressionFactory.exp("a = $a or x = $x", new Object[0]);
        Expression ep = e.paramsArray("A", 5);
        Assert.assertNotSame((Object)e, (Object)ep);
        Assert.assertEquals((Object)"(a = \"A\") or (x = 5)", (Object)ep.toString());
    }

    @Test
    public void testParams_Positional_Repeating() {
        Expression e = ExpressionFactory.exp("a = $a or x = $x and y = $x", new Object[0]);
        Expression ep = e.paramsArray("A", 5);
        Assert.assertNotSame((Object)e, (Object)ep);
        Assert.assertEquals((Object)"(a = \"A\") or ((x = 5) and (y = 5))", (Object)ep.toString());
    }

    @Test
    public void testParams_Positional_InAsValues() throws Exception {
        Expression inExp = ExpressionFactory.exp("k1 in ($ap, $bp)", new Object[0]);
        Expression transformed = inExp.paramsArray("a", "b");
        Assert.assertEquals((Object)"k1 in (\"a\", \"b\")", (Object)transformed.toString());
    }

    @Test(expected=ExpressionException.class)
    public void testParams_Positional_MoreParams() {
        Expression e = ExpressionFactory.exp("a = $a or x = $x", new Object[0]);
        e.paramsArray("A", 5, "B");
    }

    @Test(expected=ExpressionException.class)
    public void testParams_Positional_LessParams() {
        Expression e = ExpressionFactory.exp("a = $a or x = $x", new Object[0]);
        e.paramsArray("B");
    }

    @Test(expected=ExpressionException.class)
    public void testParams_Positional_NoParams() {
        Expression e = ExpressionFactory.exp("a = $a or x = $x", new Object[0]);
        e.paramsArray(new Object[0]);
    }

    @Test
    public void testParams_NullHandling_CAY847() {
        Expression e = ExpressionFactory.exp("X = $x", new Object[0]);
        e = e.params(Collections.singletonMap("x", null));
        Assert.assertEquals((Object)"X = null", (Object)e.toString());
    }

    @Test
    public void testParams_Map_Full() {
        Expression e = ExpressionFactory.exp("a = $a or x = $x", new Object[0]);
        Expression ep = e.params(new HashMap<String, Object>(){
            {
                this.put("a", "A");
                this.put("x", "X");
            }
        });
        Assert.assertNotSame((Object)e, (Object)ep);
        Assert.assertEquals((Object)"(a = \"A\") or (x = \"X\")", (Object)ep.toString());
    }

    @Test
    public void testParams_Map_Partial_Prune() {
        Expression e = ExpressionFactory.exp("a = $a or x = $x", new Object[0]);
        Expression ep = e.params(new HashMap<String, Object>(){
            {
                this.put("a", "A");
            }
        });
        Assert.assertNotSame((Object)e, (Object)ep);
        Assert.assertEquals((Object)"(a = \"A\")", (Object)ep.toString());
    }

    @Test(expected=ExpressionException.class)
    public void testParams_Map_Partial_NoPrune() {
        Expression e = ExpressionFactory.exp("a = $a or x = $x", new Object[0]);
        e.params(new HashMap<String, Object>(){
            {
                this.put("a", "A");
            }
        }, false);
    }

    @Test
    public void testCopy1() throws Exception {
        Expression e1 = ExpressionFactory.matchExp("k1", "v1");
        e1 = e1.orExp(ExpressionFactory.matchExp("k2", "v2"));
        e1 = e1.orExp(ExpressionFactory.matchExp("k3", "v3"));
        Expression e2 = e1.params(new HashMap());
        TstTraversalHandler.compareExps(e1, e2);
    }

    @Test
    public void testCopy2() throws Exception {
        Expression andExp = ExpressionFactory.matchExp("k1", "v1");
        andExp = andExp.andExp(ExpressionFactory.matchExp("k2", "v2"));
        andExp = andExp.andExp(ExpressionFactory.matchExp("k3", "v3"));
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        exprs.add(andExp);
        exprs.add(ExpressionFactory.matchExp("k1", "v1"));
        Expression e1 = ExpressionFactory.joinExp(1, exprs);
        Expression e2 = e1.params(new HashMap());
        TstTraversalHandler.compareExps(e1, e2);
    }

    @Test
    public void testInParameter() throws Exception {
        Expression inExp = ExpressionFactory.exp("k1 in $test", new Object[0]);
        Expression e1 = ExpressionFactory.exp("k1 in ('a', 'b')", new Object[0]);
        Expression transformed = inExp.params(Collections.singletonMap("test", new Object[]{"a", "b"}));
        TstTraversalHandler.compareExps(e1, transformed);
        CayenneDataObject o1 = new CayenneDataObject();
        o1.writePropertyDirectly("k1", "a");
        Assert.assertTrue((boolean)transformed.match(o1));
        CayenneDataObject o2 = new CayenneDataObject();
        o2.writePropertyDirectly("k1", "x");
        Assert.assertFalse((boolean)transformed.match(o2));
    }

    @Test
    public void testInParameter_AsValues() throws Exception {
        Expression inExp = ExpressionFactory.exp("k1 in ($ap, $bp)", new Object[0]);
        String e1String = "k1 in (\"a\", \"b\")";
        Expression e1 = ExpressionFactory.exp(e1String, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ap", "a");
        params.put("bp", "b");
        Expression transformed = inExp.params(params);
        TstTraversalHandler.compareExps(e1, transformed);
        Assert.assertEquals((Object)e1String, (Object)transformed.toString());
        CayenneDataObject o1 = new CayenneDataObject();
        o1.writePropertyDirectly("k1", "a");
        Assert.assertTrue((boolean)transformed.match(o1));
        CayenneDataObject o2 = new CayenneDataObject();
        o2.writePropertyDirectly("k1", "x");
        Assert.assertFalse((boolean)transformed.match(o2));
    }

    @Test(expected=ExpressionException.class)
    public void testFailOnMissingParams() throws Exception {
        Expression e1 = ExpressionFactory.matchExp("k1", new ExpressionParameter("test"));
        e1 = e1.orExp(ExpressionFactory.matchExp("k2", "v2"));
        e1 = e1.orExp(ExpressionFactory.matchExp("k3", "v3"));
        e1.params(new HashMap(), false);
    }

    @Test
    public void testParams1() throws Exception {
        Expression e1 = ExpressionFactory.matchExp("k1", new ExpressionParameter("test"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "xyz");
        Expression e2 = e1.params(map, false);
        Assert.assertNotNull((Object)e2);
        Assert.assertEquals((long)2L, (long)e2.getOperandCount());
        Assert.assertEquals((long)3L, (long)e2.getType());
        Assert.assertEquals((Object)"xyz", (Object)e2.getOperand(1));
    }

    @Test
    public void testParams2() throws Exception {
        Expression e1 = ExpressionFactory.likeExp("k1", new ExpressionParameter("test"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "xyz");
        Expression e2 = e1.params(map, false);
        Assert.assertNotNull((Object)e2);
        Assert.assertEquals((long)2L, (long)e2.getOperandCount());
        Assert.assertEquals((long)11L, (long)e2.getType());
        Assert.assertEquals((Object)"xyz", (Object)e2.getOperand(1));
    }

    @Test
    public void testNoParams1() throws Exception {
        Expression e1 = ExpressionFactory.matchExp("k1", new ExpressionParameter("test"));
        Expression e2 = e1.params(Collections.emptyMap());
        Assert.assertNull((Object)e2);
    }

    @Test
    public void testNoParams2() throws Exception {
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(ExpressionFactory.matchExp("k1", new ExpressionParameter("test1")));
        list.add(ExpressionFactory.matchExp("k2", new ExpressionParameter("test2")));
        list.add(ExpressionFactory.matchExp("k3", new ExpressionParameter("test3")));
        list.add(ExpressionFactory.matchExp("k4", new ExpressionParameter("test4")));
        Expression e1 = ExpressionFactory.or(list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test2", "abc");
        params.put("test3", "xyz");
        Expression e2 = e1.params(params);
        Assert.assertNotNull((Object)e2);
        Assert.assertEquals((long)2L, (long)e2.getOperandCount());
        Expression k2 = (Expression)e2.getOperand(0);
        Assert.assertEquals((Object)"abc", (Object)k2.getOperand(1));
        Expression k3 = (Expression)e2.getOperand(1);
        Assert.assertEquals((Object)"xyz", (Object)k3.getOperand(1));
    }

    @Test
    public void testNoParams3() throws Exception {
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(ExpressionFactory.matchExp("k1", new ExpressionParameter("test1")));
        list.add(ExpressionFactory.matchExp("k2", new ExpressionParameter("test2")));
        list.add(ExpressionFactory.matchExp("k3", new ExpressionParameter("test3")));
        list.add(ExpressionFactory.matchExp("k4", new ExpressionParameter("test4")));
        Expression e1 = ExpressionFactory.joinExp(1, list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test4", "123");
        Expression e2 = e1.params(params, true);
        Assert.assertNotNull((Object)e2);
        Assert.assertTrue((String)("List expression: " + e2), (!(e2 instanceof ASTList) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)e2.getOperandCount());
        Assert.assertEquals((Object)"123", (Object)e2.getOperand(1));
        Assert.assertEquals((Object)"k4", (Object)((Expression)e2.getOperand(0)).getOperand(0));
    }

    @Test
    public void testNullOptionalParameter() throws Exception {
        Expression e = ExpressionFactory.exp("abc = 3 and x = $a", new Object[0]);
        Expression e1 = e.params(Collections.EMPTY_MAP, true);
        Assert.assertEquals((Object)ExpressionFactory.exp("abc = 3", new Object[0]), (Object)e1);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("a", null);
        Expression e2 = e.params(params, true);
        Assert.assertEquals((Object)ExpressionFactory.exp("abc = 3 and x = null", new Object[0]), (Object)e2);
    }

    @Test(expected=ExpressionException.class)
    public void testNullRequiredParameter1() throws Exception {
        Expression e1 = ExpressionFactory.exp("abc = 3 and x = $a", new Object[0]);
        e1.params(Collections.EMPTY_MAP, false);
    }

    @Test
    public void testNullRequiredParameter2() throws Exception {
        Expression e1 = ExpressionFactory.exp("abc = 3 and x = $a", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("a", null);
        Expression e2 = e1.params(params, false);
        Assert.assertEquals((Object)ExpressionFactory.exp("abc = 3 and x = null", new Object[0]), (Object)e2);
    }

    @Test
    public void testNulls() {
        Expression e1 = ExpressionFactory.exp("x = null", new Object[0]);
        Expression e2 = e1.params(Collections.EMPTY_MAP, true);
        Assert.assertNotNull((Object)e2);
        TstTraversalHandler.compareExps(e1, e2);
    }

    @Test
    public void testCopy1_FromString() {
        Expression e1 = ExpressionFactory.exp("k1 = 'v1' or k2 = 'v2' or k3 = 'v3'", new Object[0]);
        Expression e2 = e1.params(Collections.EMPTY_MAP);
        TstTraversalHandler.compareExps(e1, e2);
    }

    @Test
    public void testCopy2_FromString() {
        Expression e1 = ExpressionFactory.exp("(k1 = 'v1' and k2 = 'v2' and k3 = 'v3') or (k1 = 'v1')", new Object[0]);
        Expression e2 = e1.params(Collections.EMPTY_MAP);
        TstTraversalHandler.compareExps(e1, e2);
    }

    @Test
    public void testCopy3_FromString() {
        Expression e1 = ExpressionFactory.exp("(k1 / 2) = (k2 * 2)", new Object[0]);
        Expression e2 = e1.params(Collections.EMPTY_MAP);
        TstTraversalHandler.compareExps(e1, e2);
    }

    @Test(expected=ExpressionException.class)
    public void testFailOnMissingParams_FromString() {
        Expression e1 = ExpressionFactory.exp("k1 = $test or k2 = 'v2' or k3 = 'v3'", new Object[0]);
        e1.params(Collections.EMPTY_MAP, false);
    }

    @Test
    public void testParams1_FromString() {
        Expression e1 = ExpressionFactory.exp("k1 = $test", new Object[0]);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "xyz");
        Expression e2 = e1.params(map, false);
        Assert.assertNotNull((Object)e2);
        Assert.assertEquals((long)2L, (long)e2.getOperandCount());
        Assert.assertEquals((long)3L, (long)e2.getType());
        Assert.assertEquals((Object)"xyz", (Object)e2.getOperand(1));
    }

    @Test
    public void testParams2_FromString() {
        Expression e1 = ExpressionFactory.exp("k1 like $test", new Object[0]);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "xyz");
        Expression e2 = e1.params(map, false);
        Assert.assertNotNull((Object)e2);
        Assert.assertEquals((long)2L, (long)e2.getOperandCount());
        Assert.assertEquals((long)11L, (long)e2.getType());
        Assert.assertEquals((Object)"xyz", (Object)e2.getOperand(1));
    }

    @Test
    public void testNoParams1_FromString() {
        Expression e1 = ExpressionFactory.exp("k1 = $test", new Object[0]);
        Expression e2 = e1.params(Collections.EMPTY_MAP);
        Assert.assertNull((Object)e2);
    }

    @Test
    public void testNoParams2_FromString() {
        Expression e1 = ExpressionFactory.exp("k1 = $test1 or k2 = $test2 or k3 = $test3 or k4 = $test4", new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test2", "abc");
        params.put("test3", "xyz");
        Expression e2 = e1.params(params);
        Assert.assertNotNull((Object)e2);
        Assert.assertEquals((long)2L, (long)e2.getOperandCount());
        Expression k2 = (Expression)e2.getOperand(0);
        Assert.assertEquals((Object)"abc", (Object)k2.getOperand(1));
        Expression k3 = (Expression)e2.getOperand(1);
        Assert.assertEquals((Object)"xyz", (Object)k3.getOperand(1));
    }

    @Test
    public void testNoParams3_FromString() {
        Expression e1 = ExpressionFactory.exp("k1 = $test1 or k2 = $test2 or k3 = $test3 or k4 = $test4", new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test4", "123");
        Expression e2 = e1.params(params);
        Assert.assertNotNull((Object)e2);
        Assert.assertEquals((long)2L, (long)e2.getOperandCount());
        Assert.assertEquals((Object)"123", (Object)e2.getOperand(1));
        Assert.assertEquals((Object)"k4", (Object)((Expression)e2.getOperand(0)).getOperand(0));
    }
}

