/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.query.Query;

class OracleSelectTranslator
extends SelectTranslator {
    public OracleSelectTranslator(Query query, DataNode dataNode, Connection connection) {
        super(query, dataNode, connection);
    }

    @Override
    protected void appendLimitAndOffsetClauses(StringBuilder buffer) {
        int offset = this.queryMetadata.getFetchOffset();
        int limit = this.queryMetadata.getFetchLimit();
        if (limit > 0 || offset > 0) {
            int max = limit <= 0 ? Integer.MAX_VALUE : limit + offset;
            buffer.insert(0, "select * from ( select tid.*, ROWNUM rnum from (");
            buffer.append(") tid where ROWNUM <=").append(max).append(") where rnum  > ").append(offset);
        }
    }

    @Override
    protected void appendSelectColumns(StringBuilder buffer, List<String> selectColumnExpList) {
        int columnCount = selectColumnExpList.size();
        buffer.append(selectColumnExpList.get(0)).append(" AS c0");
        for (int i = 1; i < columnCount; ++i) {
            buffer.append(", ");
            buffer.append(selectColumnExpList.get(i)).append(" AS c" + i);
        }
    }

    @Override
    public PreparedStatement createStatement() throws Exception {
        String sqlStr = this.createSqlString();
        this.logger.logQuery(sqlStr, this.values);
        PreparedStatement stmt = this.connection.prepareStatement(sqlStr);
        this.initStatement(stmt);
        return stmt;
    }
}

