/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.firebird;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AddColumnToDb;
import org.apache.cayenne.merge.DropColumnToDb;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.SetAllowNullToDb;
import org.apache.cayenne.merge.SetNotNullToDb;

public class FirebirdMergerFactory
extends MergerFactory {
    @Override
    public MergerToken createDropColumnToDb(DbEntity entity, DbAttribute column) {
        return new DropColumnToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                QuotingStrategy quoting = adapter.getQuotingStrategy();
                return Collections.singletonList("ALTER TABLE " + quoting.quotedFullyQualifiedName(this.getEntity()) + " DROP " + quoting.quotedName(this.getColumn()));
            }
        };
    }

    @Override
    public MergerToken createSetNotNullToDb(DbEntity entity, DbAttribute column) {
        return new SetNotNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                QuotingStrategy context = adapter.getQuotingStrategy();
                String entityName = context.quotedFullyQualifiedName(this.getEntity());
                String columnName = context.quotedName(this.getColumn());
                return Collections.singletonList(String.format("UPDATE RDB$RELATION_FIELDS SET RDB$NULL_FLAG = 1 WHERE RDB$FIELD_NAME = '%s' AND RDB$RELATION_NAME = '%s'", columnName, entityName));
            }
        };
    }

    @Override
    public MergerToken createSetAllowNullToDb(DbEntity entity, DbAttribute column) {
        return new SetAllowNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                QuotingStrategy context = adapter.getQuotingStrategy();
                String entityName = context.quotedFullyQualifiedName(this.getEntity());
                String columnName = context.quotedName(this.getColumn());
                return Collections.singletonList(String.format("UPDATE RDB$RELATION_FIELDS SET RDB$NULL_FLAG = NULL  WHERE RDB$FIELD_NAME = '%s' AND RDB$RELATION_NAME = '%s'", columnName, entityName));
            }
        };
    }

    @Override
    public MergerToken createAddColumnToDb(DbEntity entity, DbAttribute column) {
        return new AddColumnToDb(entity, column){

            @Override
            protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quotedFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" ADD ");
                sqlBuffer.append(context.quotedName(this.getColumn()));
                sqlBuffer.append(" ");
            }
        };
    }
}

