/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.derby;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.derby.DerbyEJBQLTranslatorFactory;
import org.apache.cayenne.dba.derby.DerbyMergerFactory;
import org.apache.cayenne.dba.derby.DerbyPkGenerator;
import org.apache.cayenne.dba.derby.DerbyQualifierTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.resource.ResourceLocator;

public class DerbyAdapter
extends JdbcAdapter {
    static final String FOR_BIT_DATA_SUFFIX = " FOR BIT DATA";

    public DerbyAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject ResourceLocator resourceLocator) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator);
        this.setSupportsGeneratedKeys(true);
        this.setSupportsBatchUpdates(true);
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new DerbyPkGenerator(this);
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, true));
        map.registerType(new ShortType(true));
        map.registerType(new ByteType(true));
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String[] types = this.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? column.getEntity().getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '" + entityName + "." + column.getName() + "': " + column.getType(), new Object[0]);
        }
        sqlBuffer.append(this.quotingStrategy.quotedName(column));
        sqlBuffer.append(' ');
        String type = types[0];
        String length = DerbyAdapter.sizeAndPrecision(this, column);
        int suffixIndex = type.indexOf(FOR_BIT_DATA_SUFFIX);
        if (!length.isEmpty() && suffixIndex > 0) {
            sqlBuffer.append(type.substring(0, suffixIndex)).append(length).append(FOR_BIT_DATA_SUFFIX);
        } else {
            sqlBuffer.append(type).append(" ").append(length);
        }
        if (column.isMandatory()) {
            sqlBuffer.append(" NOT NULL");
        }
        if (column.isGenerated()) {
            sqlBuffer.append(" GENERATED BY DEFAULT AS IDENTITY");
        }
    }

    @Override
    public boolean typeSupportsLength(int type) {
        switch (type) {
            case 2004: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return super.typeSupportsLength(type);
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        DerbyQualifierTranslator translator = new DerbyQualifierTranslator(queryAssembler, "RTRIM");
        translator.setCaseInsensitive(this.caseInsensitiveCollations);
        return translator;
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        DerbyEJBQLTranslatorFactory translatorFactory = new DerbyEJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    @Override
    public MergerFactory mergerFactory() {
        return new DerbyMergerFactory();
    }

    @Override
    public void bindParameter(PreparedStatement statement, Object object, int pos, int sqlType, int precision) throws SQLException, Exception {
        if (object == null && sqlType == 0) {
            statement.setNull(pos, 12);
        } else {
            super.bindParameter(statement, object, pos, this.convertNTypes(sqlType), precision);
        }
    }

    private int convertNTypes(int sqlType) {
        switch (sqlType) {
            case -15: {
                return 1;
            }
            case -9: {
                return 12;
            }
            case -16: {
                return -1;
            }
            case 2011: {
                return 2005;
            }
        }
        return sqlType;
    }
}

