/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.sql.Connection;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PoolManagerIT
extends ServerCase {
    @Inject
    private DataSourceInfo dataSourceInfo;

    @Test
    public void testDataSourceUrl() throws Exception {
        String driverName = this.dataSourceInfo.getJdbcDriver();
        String url = this.dataSourceInfo.getDataSourceUrl();
        PoolManager pm = new PoolManager(driverName, url, 0, 3, "", ""){

            @Override
            protected void startMaintenanceThread() {
            }
        };
        Assert.assertEquals((Object)url, (Object)pm.getDataSourceUrl());
        Assert.assertEquals((Object)driverName, (Object)pm.getJdbcDriver());
    }

    @Test
    public void testPassword() throws Exception {
        PoolManager pm = new PoolManager(null, 0, 3, "", "b"){

            @Override
            protected void startMaintenanceThread() {
            }
        };
        Assert.assertEquals((Object)"b", (Object)pm.getPassword());
    }

    @Test
    public void testUserName() throws Exception {
        PoolManager pm = new PoolManager(null, 0, 3, "a", ""){

            @Override
            protected void startMaintenanceThread() {
            }
        };
        Assert.assertEquals((Object)"a", (Object)pm.getUserName());
    }

    @Test
    public void testMinConnections() throws Exception {
        PoolManager pm = new PoolManager(null, 0, 3, "", ""){

            @Override
            protected void startMaintenanceThread() {
            }
        };
        Assert.assertEquals((long)0L, (long)pm.getMinConnections());
    }

    @Test
    public void testMaxConnections() throws Exception {
        PoolManager pm = new PoolManager(null, 0, 3, "", ""){

            @Override
            protected void startMaintenanceThread() {
            }
        };
        Assert.assertEquals((long)3L, (long)pm.getMaxConnections());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPooling() throws Exception {
        PoolManager pm = new PoolManager(this.dataSourceInfo.getJdbcDriver(), this.dataSourceInfo.getDataSourceUrl(), 2, 3, this.dataSourceInfo.getUserName(), this.dataSourceInfo.getPassword());
        try {
            Assert.assertEquals((long)0L, (long)pm.getCurrentlyInUse());
            Assert.assertEquals((long)2L, (long)pm.getCurrentlyUnused());
            Connection c1 = pm.getConnection();
            Assert.assertEquals((long)1L, (long)pm.getCurrentlyInUse());
            Assert.assertEquals((long)1L, (long)pm.getCurrentlyUnused());
            Connection c2 = pm.getConnection();
            Assert.assertEquals((long)2L, (long)pm.getCurrentlyInUse());
            Assert.assertEquals((long)0L, (long)pm.getCurrentlyUnused());
            c1.close();
            Assert.assertEquals((long)1L, (long)pm.getCurrentlyInUse());
            Assert.assertEquals((long)1L, (long)pm.getCurrentlyUnused());
            c2.close();
            Assert.assertEquals((long)0L, (long)pm.getCurrentlyInUse());
            Assert.assertEquals((long)2L, (long)pm.getCurrentlyUnused());
        }
        finally {
            pm.shutdown();
        }
    }
}

