/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.util.Util;

public class DriverDataSource
implements DataSource {
    protected Driver _driver;
    protected String driverClassName;
    protected String connectionUrl;
    protected String userName;
    protected String password;
    protected JdbcEventLogger logger;

    @Deprecated
    private static Driver loadDriver(String driverClassName) throws SQLException {
        Class<?> driverClass;
        try {
            driverClass = Util.getJavaClass(driverClassName);
        }
        catch (Exception ex) {
            throw new SQLException("Can not load JDBC driver named '" + driverClassName + "': " + ex.getMessage());
        }
        try {
            return (Driver)driverClass.newInstance();
        }
        catch (Exception ex) {
            throw new SQLException("Error instantiating driver '" + driverClassName + "': " + ex.getMessage());
        }
    }

    public DriverDataSource(String driverClassName, String connectionUrl) {
        this(driverClassName, connectionUrl, null, null);
    }

    public DriverDataSource(String driverClassName, String connectionUrl, String userName, String password) {
        this.setDriverClassName(driverClassName);
        this.connectionUrl = connectionUrl;
        this.userName = userName;
        this.password = password;
    }

    public DriverDataSource(Driver driver, String connectionUrl, String userName, String password) {
        this._driver = driver;
        this.driverClassName = driver.getClass().getName();
        this.connectionUrl = connectionUrl;
        this.userName = userName;
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            if (this.logger != null) {
                this.logger.logConnect(this.connectionUrl, userName, password);
            }
            Connection c = null;
            if (this.getDriver() == null) {
                c = DriverManager.getConnection(this.connectionUrl, userName, password);
            } else {
                Properties connectProperties = new Properties();
                if (userName != null) {
                    connectProperties.put("user", userName);
                }
                if (password != null) {
                    connectProperties.put("password", password);
                }
                c = this.getDriver().connect(this.connectionUrl, connectProperties);
            }
            if (c == null) {
                throw new SQLException("Can't establish connection: " + this.connectionUrl);
            }
            if (this.logger != null) {
                this.logger.logConnectSuccess();
            }
            return c;
        }
        catch (SQLException sqlex) {
            if (this.logger != null) {
                this.logger.logConnectFailure(sqlex);
            }
            throw sqlex;
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return -1;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public JdbcEventLogger getLogger() {
        return this.logger;
    }

    public void setLogger(JdbcEventLogger delegate) {
        this.logger = delegate;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        if (!Util.nullSafeEquals(this.getDriverClassName(), driverClassName)) {
            this.driverClassName = driverClassName;
            this._driver = null;
        }
    }

    private Driver getDriver() throws SQLException {
        if (this._driver == null && this.driverClassName != null) {
            this._driver = DriverDataSource.loadDriver(this.driverClassName);
        }
        return this._driver;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }
}

