/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.sql.Connection;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.select.TstQueryAssembler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class QueryAssemblerIT
extends ServerCase {
    @Inject
    private DataNode dataNode;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;
    private Connection connection;
    private TstQueryAssembler qa;

    @Before
    public void setUp() throws Exception {
        this.connection = this.dataSourceFactory.getSharedDataSource().getConnection();
        this.qa = new TstQueryAssembler(new SelectQuery(), this.dataNode, this.connection);
    }

    @After
    public void tearDown() throws Exception {
        this.connection.close();
    }

    @Test
    public void testGetQuery() throws Exception {
        Assert.assertNotNull((Object)this.qa.getQuery());
    }

    @Test
    public void testAddToParamList() throws Exception {
        Assert.assertEquals((long)0L, (long)this.qa.getAttributes().size());
        Assert.assertEquals((long)0L, (long)this.qa.getValues().size());
        this.qa.addToParamList(new DbAttribute(), new Object());
        Assert.assertEquals((long)1L, (long)this.qa.getAttributes().size());
        Assert.assertEquals((long)1L, (long)this.qa.getValues().size());
    }

    @Test
    public void testCreateStatement() throws Exception {
        Assert.assertNotNull((Object)this.qa.createStatement());
    }
}

