/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.EntityFilters;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.junit.Assert;
import org.junit.Test;

public class EntityFiltersTest {
    @Test
    public void testJoinWithEmpty() throws Exception {
        EntityFilters filter1 = new EntityFilters(null, null, null, null);
        EntityFilters filter2 = new EntityFilters(null, FilterFactory.include("table"), FilterFactory.include("column"), FilterFactory.include("procedure"));
        Assert.assertEquals((Object)filter2, (Object)filter1.join(filter2));
        Assert.assertEquals((Object)filter2, (Object)filter2.join(filter1));
    }

    @Test
    public void testJoinExcludeInclude() throws Exception {
        EntityFilters filter1 = new EntityFilters(null, FilterFactory.exclude("table"), FilterFactory.exclude("column"), FilterFactory.exclude("procedure"));
        EntityFilters filter2 = new EntityFilters(null, FilterFactory.include("table"), FilterFactory.include("column"), FilterFactory.include("procedure"));
        Assert.assertEquals((Object)new EntityFilters(null, FilterFactory.list(FilterFactory.exclude("table"), FilterFactory.include("table")), FilterFactory.list(FilterFactory.exclude("column"), FilterFactory.include("column")), FilterFactory.list(FilterFactory.exclude("procedure"), FilterFactory.include("procedure"))), (Object)filter1.join(filter2));
        Assert.assertEquals((Object)new EntityFilters(null, FilterFactory.list(FilterFactory.include("table"), FilterFactory.exclude("table")), FilterFactory.list(FilterFactory.include("column"), FilterFactory.exclude("column")), FilterFactory.list(FilterFactory.include("procedure"), FilterFactory.exclude("procedure"))), (Object)filter2.join(filter1));
    }

    @Test
    public void testEquals() throws Exception {
        EntityFilters filters = new EntityFilters(new DbPath(), FilterFactory.NULL, FilterFactory.NULL, FilterFactory.NULL);
        Assert.assertTrue((boolean)filters.tableFilter().equals(FilterFactory.NULL));
        Assert.assertTrue((boolean)filters.columnFilter().equals(FilterFactory.NULL));
        Assert.assertTrue((boolean)filters.procedureFilter().equals(FilterFactory.NULL));
    }
}

