/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader;

import java.net.URL;
import java.util.ArrayList;
import org.apache.cayenne.access.loader.ManyToManyCandidateEntity;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DefaultConfigurationNameMapper;
import org.apache.cayenne.configuration.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.configuration.XMLDataMapLoader;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.naming.LegacyNameGenerator;
import org.apache.cayenne.resource.URLResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManyToManyCandidateEntityTest {
    private DataMap map;

    @Before
    public void setUp() throws Exception {
        Module testModule = new Module(){

            public void configure(Binder binder) {
                binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
                binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
                binder.bind(DataMapLoader.class).to(XMLDataMapLoader.class);
                binder.bind(ConfigurationNameMapper.class).to(DefaultConfigurationNameMapper.class);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        injector.injectMembers((Object)loader);
        String testConfigName = "relationship-optimisation";
        URL url = this.getClass().getResource("cayenne-" + testConfigName + ".xml");
        ConfigurationTree<DataChannelDescriptor> tree = loader.load(new URLResource(url));
        this.map = tree.getRootNode().getDataMap(testConfigName);
    }

    @Test
    public void testMatchingForManyToManyEntity() throws Exception {
        ObjEntity manyToManyEntity = this.map.getObjEntity("Table1Table2");
        Assert.assertNotNull((Object)ManyToManyCandidateEntity.build(manyToManyEntity));
    }

    @Test
    public void testMatchingForNotManyToManyEntity() throws Exception {
        ObjEntity entity = this.map.getObjEntity("Table1");
        Assert.assertNull((Object)ManyToManyCandidateEntity.build(entity));
    }

    @Test
    public void testOptimisationForManyToManyEntity() {
        ObjEntity manyToManyEntity = this.map.getObjEntity("Table1Table2");
        ManyToManyCandidateEntity.build(manyToManyEntity).optimizeRelationships(new LegacyNameGenerator());
        ObjEntity table1Entity = this.map.getObjEntity("Table1");
        ObjEntity table2Entity = this.map.getObjEntity("Table2");
        Assert.assertEquals((long)1L, (long)table1Entity.getRelationships().size());
        Assert.assertEquals((Object)table2Entity, (Object)((Relationship)new ArrayList<ObjRelationship>(table1Entity.getRelationships()).get(0)).getTargetEntity());
        Assert.assertEquals((long)1L, (long)table2Entity.getRelationships().size());
        Assert.assertEquals((Object)table1Entity, (Object)((Relationship)new ArrayList<ObjRelationship>(table2Entity.getRelationships()).get(0)).getTargetEntity());
    }
}

