/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.embeddable.EmbedEntity1;
import org.apache.cayenne.testdo.embeddable.Embeddable1;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-embeddable.xml")
public class EmbeddingIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tEmbedEntity1;

    @Before
    public void setUp() throws Exception {
        this.tEmbedEntity1 = new TableHelper(this.dbHelper, "EMBED_ENTITY1");
        this.tEmbedEntity1.setColumns(new String[]{"ID", "NAME", "EMBEDDED10", "EMBEDDED20", "EMBEDDED30", "EMBEDDED40"});
    }

    protected void createSelectDataSet() throws Exception {
        this.tEmbedEntity1.delete().execute();
        this.tEmbedEntity1.insert(new Object[]{1, "n1", "e1", "e2", "e3", "e4"});
        this.tEmbedEntity1.insert(new Object[]{2, "n2", "ex1", "ex2", "ex3", "ex4"});
    }

    protected void createUpdateDataSet() throws Exception {
        this.tEmbedEntity1.delete().execute();
        this.tEmbedEntity1.insert(new Object[]{1, "n1", "e1", "e2", "e3", "e4"});
    }

    @Test
    public void testSelect() throws Exception {
        this.createSelectDataSet();
        SelectQuery<EmbedEntity1> query = new SelectQuery<EmbedEntity1>(EmbedEntity1.class);
        query.addOrdering("name", SortOrder.ASCENDING);
        List results = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)results.size());
        EmbedEntity1 o1 = (EmbedEntity1)results.get(0);
        Assert.assertEquals((Object)"n1", (Object)o1.getName());
        Embeddable1 e11 = o1.getEmbedded1();
        Embeddable1 e12 = o1.getEmbedded2();
        Assert.assertNotNull((Object)e11);
        Assert.assertNotNull((Object)e12);
        Assert.assertEquals((Object)"e1", (Object)e11.getEmbedded10());
        Assert.assertEquals((Object)"e2", (Object)e11.getEmbedded20());
        Assert.assertEquals((Object)"e3", (Object)e12.getEmbedded10());
        Assert.assertEquals((Object)"e4", (Object)e12.getEmbedded20());
        EmbedEntity1 o2 = (EmbedEntity1)results.get(1);
        Assert.assertEquals((Object)"n2", (Object)o2.getName());
        Embeddable1 e21 = o2.getEmbedded1();
        Embeddable1 e22 = o2.getEmbedded2();
        Assert.assertNotNull((Object)e21);
        Assert.assertNotNull((Object)e22);
        Assert.assertEquals((Object)"ex1", (Object)e21.getEmbedded10());
        Assert.assertEquals((Object)"ex2", (Object)e21.getEmbedded20());
        Assert.assertEquals((Object)"ex3", (Object)e22.getEmbedded10());
        Assert.assertEquals((Object)"ex4", (Object)e22.getEmbedded20());
    }

    @Test
    public void testInsert() throws Exception {
        EmbedEntity1 o1 = this.context.newObject(EmbedEntity1.class);
        o1.setName("NAME");
        Embeddable1 e1 = new Embeddable1();
        e1.setEmbedded10("E11");
        e1.setEmbedded20("E12");
        o1.setEmbedded1(e1);
        Embeddable1 e2 = new Embeddable1();
        o1.setEmbedded2(e2);
        e2.setEmbedded10("E21");
        e2.setEmbedded20("E22");
        this.context.commitChanges();
        SelectQuery<EmbedEntity1> query = new SelectQuery<EmbedEntity1>(EmbedEntity1.class);
        query.setFetchingDataRows(true);
        DataRow row = (DataRow)Cayenne.objectForQuery(this.context, query);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"E11", row.get("EMBEDDED10"));
        Assert.assertEquals((Object)"E12", row.get("EMBEDDED20"));
        Assert.assertEquals((Object)"E21", row.get("EMBEDDED30"));
        Assert.assertEquals((Object)"E22", row.get("EMBEDDED40"));
    }

    @Test
    public void testUpdateEmbeddedProperties() throws Exception {
        this.createUpdateDataSet();
        SelectQuery<EmbedEntity1> query = new SelectQuery<EmbedEntity1>(EmbedEntity1.class);
        query.addOrdering("name", SortOrder.ASCENDING);
        List results = this.context.performQuery(query);
        EmbedEntity1 o1 = (EmbedEntity1)results.get(0);
        Embeddable1 e11 = o1.getEmbedded1();
        e11.setEmbedded10("x1");
        Assert.assertEquals((long)4L, (long)o1.getPersistenceState());
        this.context.commitChanges();
        SelectQuery<EmbedEntity1> query1 = new SelectQuery<EmbedEntity1>(EmbedEntity1.class);
        query1.setFetchingDataRows(true);
        DataRow row = (DataRow)Cayenne.objectForQuery(this.context, query1);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"x1", row.get("EMBEDDED10"));
    }

    @Test
    public void testUpdateEmbedded() throws Exception {
        this.createUpdateDataSet();
        SelectQuery<EmbedEntity1> query = new SelectQuery<EmbedEntity1>(EmbedEntity1.class);
        query.addOrdering("name", SortOrder.ASCENDING);
        List results = this.context.performQuery(query);
        EmbedEntity1 o1 = (EmbedEntity1)results.get(0);
        Embeddable1 e11 = new Embeddable1();
        e11.setEmbedded10("x1");
        e11.setEmbedded20("x2");
        o1.setEmbedded1(e11);
        Assert.assertEquals((long)4L, (long)o1.getPersistenceState());
        this.context.commitChanges();
        SelectQuery<EmbedEntity1> query1 = new SelectQuery<EmbedEntity1>(EmbedEntity1.class);
        query1.setFetchingDataRows(true);
        DataRow row = (DataRow)Cayenne.objectForQuery(this.context, query1);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"x1", row.get("EMBEDDED10"));
    }
}

