/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.loader.DbLoaderConfiguration;
import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DbLoaderIT
extends ServerCase {
    public static final DbLoaderConfiguration CONFIG = new DbLoaderConfiguration();
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DbAdapter adapter;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    private DbLoader loader;

    @Before
    public void setUp() throws Exception {
        this.loader = new DbLoader(this.dataSourceFactory.getSharedDataSource().getConnection(), this.adapter, null);
    }

    @After
    public void tearDown() throws Exception {
        this.loader.getConnection().close();
    }

    @Test
    public void testGetTableTypes() throws Exception {
        String viewLabel;
        List<String> tableTypes = this.loader.getTableTypes();
        Assert.assertNotNull(tableTypes);
        String tableLabel = this.adapter.tableTypeForTable();
        if (tableLabel != null) {
            Assert.assertTrue((String)("Missing type for table '" + tableLabel + "' - " + tableTypes), (boolean)tableTypes.contains(tableLabel));
        }
        if ((viewLabel = this.adapter.tableTypeForView()) != null) {
            Assert.assertTrue((String)("Missing type for view '" + viewLabel + "' - " + tableTypes), (boolean)tableTypes.contains(viewLabel));
        }
    }

    @Test
    public void testGetTables() throws Exception {
        String tableLabel = this.adapter.tableTypeForTable();
        Collection<DbEntity> tables = this.loader.getTables(new DbLoaderConfiguration(), new String[]{tableLabel}).values().iterator().next().values();
        Assert.assertNotNull(tables);
        boolean foundArtist = false;
        for (DbEntity table : tables) {
            if (!"ARTIST".equalsIgnoreCase(table.getName())) continue;
            foundArtist = true;
            break;
        }
        Assert.assertTrue((String)("'ARTIST' is missing from the table list: " + tables), (boolean)foundArtist);
    }

    @Test
    public void testLoadWithMeaningfulPK() throws Exception {
        DataMap map = new DataMap();
        String[] tableLabel = new String[]{this.adapter.tableTypeForTable()};
        this.loader.setCreatingMeaningfulPK(true);
        Map<DbPath, Map<String, DbEntity>> testLoader = this.loader.getTables(CONFIG, tableLabel);
        if (testLoader.isEmpty()) {
            testLoader = this.loader.getTables(CONFIG, tableLabel);
        }
        List<DbEntity> entities = this.loader.loadDbEntities(map, CONFIG, testLoader);
        this.loader.loadObjEntities(map, CONFIG, entities);
        ObjEntity artist = map.getObjEntity("Artist");
        Assert.assertNotNull((Object)artist);
        ObjAttribute id = artist.getAttribute("artistId");
        Assert.assertNotNull((Object)id);
    }

    @Test
    public void testLoad() throws Exception {
        boolean supportsUnique = this.runtime.getDataDomain().getDataNodes().iterator().next().getAdapter().supportsUniqueConstraints();
        boolean supportsLobs = this.accessStackAdapter.supportsLobs();
        boolean supportsFK = this.accessStackAdapter.supportsFKConstraints();
        DataMap map = new DataMap();
        map.setDefaultPackage("foo.x");
        String tableLabel = this.adapter.tableTypeForTable();
        List<DbEntity> entities = this.loader.loadDbEntities(map, CONFIG, this.loader.getTables(CONFIG, new String[]{tableLabel}));
        this.assertDbEntities(map);
        if (supportsLobs) {
            this.assertLobDbEntities(map);
        }
        HashMap<DbPath, Map<String, DbEntity>> tables = new HashMap<DbPath, Map<String, DbEntity>>();
        HashMap<String, DbEntity> value = new HashMap<String, DbEntity>();
        for (DbEntity e : entities) {
            value.put(e.getName(), e);
        }
        tables.put(new DbPath(), value);
        this.loader.loadDbRelationships(CONFIG, tables);
        if (supportsFK) {
            Collection<DbRelationship> rels = this.getDbEntity(map, "ARTIST").getRelationships();
            Assert.assertNotNull(rels);
            Assert.assertTrue((!rels.isEmpty() ? 1 : 0) != 0);
            rels = this.getDbEntity(map, "PAINTING").getRelationships();
            Assert.assertNotNull(rels);
            Relationship oneToOne = null;
            for (DbRelationship rel : rels) {
                if (!"PAINTING_INFO".equalsIgnoreCase(rel.getTargetEntityName())) continue;
                oneToOne = rel;
                break;
            }
            Assert.assertNotNull((String)"No relationship to PAINTING_INFO", oneToOne);
            Assert.assertFalse((String)"Relationship to PAINTING_INFO must be to-one", (boolean)oneToOne.isToMany());
            Assert.assertTrue((String)"Relationship to PAINTING_INFO must be to-one", (boolean)((DbRelationship)oneToOne).isToDependentPK());
            if (supportsUnique) {
                this.assertUniqueConstraintsInRelationships(map);
            }
        }
        this.loader.setCreatingMeaningfulPK(false);
        this.loader.loadObjEntities(map, CONFIG, entities);
        this.assertObjEntities(map);
        if (this.accessStackAdapter.supportsColumnTypeReengineering()) {
            this.checkTypes(map);
        }
    }

    private void assertUniqueConstraintsInRelationships(DataMap map) {
    }

    private void assertDbEntities(DataMap map) {
        DbEntity dae = this.getDbEntity(map, "ARTIST");
        Assert.assertNotNull((String)("Null 'ARTIST' entity, other DbEntities: " + map.getDbEntityMap()), (Object)dae);
        Assert.assertEquals((Object)"ARTIST", (Object)dae.getName().toUpperCase());
        DbAttribute a = this.getDbAttribute(dae, "ARTIST_ID");
        Assert.assertNotNull((Object)a);
        Assert.assertTrue((boolean)a.isPrimaryKey());
        Assert.assertFalse((boolean)a.isGenerated());
        if (this.adapter.supportsGeneratedKeys()) {
            DbEntity bag = this.getDbEntity(map, "GENERATED_COLUMN_TEST");
            DbAttribute id = bag.getAttribute("GENERATED_COLUMN");
            Assert.assertTrue((boolean)id.isPrimaryKey());
            Assert.assertTrue((boolean)id.isGenerated());
        }
    }

    private void assertObjEntities(DataMap map) {
        boolean supportsLobs = this.accessStackAdapter.supportsLobs();
        boolean supportsFK = this.accessStackAdapter.supportsFKConstraints();
        ObjEntity ae = map.getObjEntity("Artist");
        Assert.assertNotNull((Object)ae);
        Assert.assertEquals((Object)"Artist", (Object)ae.getName());
        Assert.assertNull((Object)ae.getAttribute("artistId"));
        if (supportsLobs) {
            this.assertLobObjEntities(map);
        }
        if (supportsFK) {
            Collection<ObjRelationship> rels1 = ae.getRelationships();
            Assert.assertNotNull(rels1);
            Assert.assertTrue((rels1.size() > 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((Object)"foo.x.Artist", (Object)ae.getClassName());
    }

    private void assertLobDbEntities(DataMap map) {
        DbEntity blobEnt = this.getDbEntity(map, "BLOB_TEST");
        Assert.assertNotNull((Object)blobEnt);
        DbAttribute blobAttr = this.getDbAttribute(blobEnt, "BLOB_COL");
        Assert.assertNotNull((Object)blobAttr);
        Assert.assertTrue((String)DbLoaderIT.msgForTypeMismatch(2004, blobAttr), (2004 == blobAttr.getType() || -4 == blobAttr.getType() ? 1 : 0) != 0);
        DbEntity clobEnt = this.getDbEntity(map, "CLOB_TEST");
        Assert.assertNotNull((Object)clobEnt);
        DbAttribute clobAttr = this.getDbAttribute(clobEnt, "CLOB_COL");
        Assert.assertNotNull((Object)clobAttr);
        Assert.assertTrue((String)DbLoaderIT.msgForTypeMismatch(2005, clobAttr), (2005 == clobAttr.getType() || -1 == clobAttr.getType() ? 1 : 0) != 0);
    }

    private void assertLobObjEntities(DataMap map) {
        ObjEntity blobEnt = map.getObjEntity("BlobTest");
        Assert.assertNotNull((Object)blobEnt);
        ObjAttribute blobAttr = blobEnt.getAttribute("blobCol");
        Assert.assertNotNull((String)"BlobTest.blobCol failed to doLoad", (Object)blobAttr);
        Assert.assertEquals((Object)"byte[]", (Object)blobAttr.getType());
        ObjEntity clobEnt = map.getObjEntity("ClobTest");
        Assert.assertNotNull((Object)clobEnt);
        ObjAttribute clobAttr = clobEnt.getAttribute("clobCol");
        Assert.assertNotNull((Object)clobAttr);
        Assert.assertEquals((Object)String.class.getName(), (Object)clobAttr.getType());
        ObjEntity nclobEnt = map.getObjEntity("NclobTest");
        Assert.assertNotNull((Object)nclobEnt);
        ObjAttribute nclobAttr = nclobEnt.getAttribute("nclobCol");
        Assert.assertNotNull((Object)nclobAttr);
        Assert.assertEquals((Object)String.class.getName(), (Object)nclobAttr.getType());
    }

    private DbEntity getDbEntity(DataMap map, String name) {
        DbEntity de = map.getDbEntity(name);
        if (de == null) {
            de = map.getDbEntity(name.toLowerCase());
        }
        return de;
    }

    private DbAttribute getDbAttribute(DbEntity ent, String name) {
        DbAttribute da = ent.getAttribute(name);
        if (da == null) {
            da = ent.getAttribute(name.toLowerCase());
        }
        return da;
    }

    private DataMap originalMap() {
        return this.runtime.getDataDomain().getDataNodes().iterator().next().getDataMaps().iterator().next();
    }

    public void checkTypes(DataMap map) {
        DbEntity dbe = this.getDbEntity(map, "PAINTING");
        DbEntity floatTest = this.getDbEntity(map, "FLOAT_TEST");
        DbEntity smallintTest = this.getDbEntity(map, "SMALLINT_TEST");
        DbAttribute integerAttr = this.getDbAttribute(dbe, "PAINTING_ID");
        DbAttribute decimalAttr = this.getDbAttribute(dbe, "ESTIMATED_PRICE");
        DbAttribute varcharAttr = this.getDbAttribute(dbe, "PAINTING_TITLE");
        DbAttribute floatAttr = this.getDbAttribute(floatTest, "FLOAT_COL");
        DbAttribute smallintAttr = this.getDbAttribute(smallintTest, "SMALLINT_COL");
        Assert.assertTrue((String)DbLoaderIT.msgForTypeMismatch(3, decimalAttr), (3 == decimalAttr.getType() || 2 == decimalAttr.getType() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)decimalAttr.getScale());
        Assert.assertEquals((String)DbLoaderIT.msgForTypeMismatch(12, varcharAttr), (long)12L, (long)varcharAttr.getType());
        Assert.assertEquals((long)255L, (long)varcharAttr.getMaxLength());
        Assert.assertEquals((String)DbLoaderIT.msgForTypeMismatch(4, integerAttr), (long)4L, (long)integerAttr.getType());
        Assert.assertTrue((String)DbLoaderIT.msgForTypeMismatch(6, floatAttr), (6 == floatAttr.getType() || 8 == floatAttr.getType() || 7 == floatAttr.getType() ? 1 : 0) != 0);
        Assert.assertTrue((String)DbLoaderIT.msgForTypeMismatch(5, smallintAttr), (5 == smallintAttr.getType() || 4 == smallintAttr.getType() ? 1 : 0) != 0);
    }

    public void checkAllDBEntities(DataMap map) {
        for (DbEntity origEnt : this.originalMap().getDbEntities()) {
            DbEntity newEnt = map.getDbEntity(origEnt.getName());
            for (DbAttribute origAttr : origEnt.getAttributes()) {
                DbAttribute newAttr = newEnt.getAttribute(origAttr.getName());
                Assert.assertNotNull((String)("No matching DbAttribute for '" + origAttr.getName()), (Object)newAttr);
                Assert.assertEquals((String)DbLoaderIT.msgForTypeMismatch(origAttr, newAttr), (long)origAttr.getType(), (long)newAttr.getType());
                Assert.assertTrue((origAttr.getMaxLength() <= newAttr.getMaxLength() ? 1 : 0) != 0);
                Assert.assertTrue((origAttr.getScale() <= newAttr.getScale() ? 1 : 0) != 0);
            }
        }
    }

    private static String msgForTypeMismatch(DbAttribute origAttr, DbAttribute newAttr) {
        return DbLoaderIT.msgForTypeMismatch(origAttr.getType(), newAttr);
    }

    private static String msgForTypeMismatch(int origType, DbAttribute newAttr) {
        String nt = TypesMapping.getSqlNameByType(newAttr.getType());
        String ot = TypesMapping.getSqlNameByType(origType);
        return DbLoaderIT.attrMismatch(newAttr.getName(), "expected type: <" + ot + ">, but was <" + nt + ">");
    }

    private static String attrMismatch(String attrName, String msg) {
        return "[Error loading attribute '" + attrName + "': " + msg + "]";
    }
}

