/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.HashMap;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataRowStoreIT
extends ServerCase {
    @Test
    public void testDefaultConstructor() {
        DataRowStore cache = new DataRowStore("cacheXYZ", Collections.EMPTY_MAP, new DefaultEventManager());
        Assert.assertEquals((Object)"cacheXYZ", (Object)cache.getName());
        Assert.assertNotNull((Object)cache.getSnapshotEventSubject());
        Assert.assertTrue((boolean)cache.getSnapshotEventSubject().getSubjectName().contains("cacheXYZ"));
        Assert.assertEquals((Object)false, (Object)cache.isNotifyingRemoteListeners());
    }

    @Test
    public void testConstructorWithProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cayenne.DataRowStore.remote.notify", String.valueOf(true));
        DataRowStore cache = new DataRowStore("cacheXYZ", props, new DefaultEventManager());
        Assert.assertEquals((Object)"cacheXYZ", (Object)cache.getName());
        Assert.assertEquals((Object)true, (Object)cache.isNotifyingRemoteListeners());
    }

    @Test
    public void testNotifyingRemoteListeners() {
        DataRowStore cache = new DataRowStore("cacheXYZ", Collections.EMPTY_MAP, new DefaultEventManager());
        Assert.assertEquals((Object)false, (Object)cache.isNotifyingRemoteListeners());
        cache.setNotifyingRemoteListeners(true);
        Assert.assertEquals((Object)true, (Object)cache.isNotifyingRemoteListeners());
    }

    @Test
    public void testMaxSize() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cayenne.DataRowStore.snapshot.size", String.valueOf(2));
        DataRowStore cache = new DataRowStore("cacheXYZ", props, new DefaultEventManager());
        Assert.assertEquals((long)2L, (long)cache.maximumSize());
        Assert.assertEquals((long)0L, (long)cache.size());
        ObjectId key1 = new ObjectId("Artist", "ARTIST_ID", 1);
        HashMap<ObjectId, DataRow> diff1 = new HashMap<ObjectId, DataRow>();
        diff1.put(key1, new DataRow(1));
        ObjectId key2 = new ObjectId("Artist", "ARTIST_ID", 2);
        HashMap<ObjectId, DataRow> diff2 = new HashMap<ObjectId, DataRow>();
        diff2.put(key2, new DataRow(1));
        ObjectId key3 = new ObjectId("Artist", "ARTIST_ID", 3);
        HashMap<ObjectId, DataRow> diff3 = new HashMap<ObjectId, DataRow>();
        diff3.put(key3, new DataRow(1));
        cache.processSnapshotChanges(this, diff1, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.processSnapshotChanges(this, diff2, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        Assert.assertEquals((long)2L, (long)cache.size());
        cache.processSnapshotChanges(this, diff3, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertNotNull((Object)cache.getCachedSnapshot(key2));
        Assert.assertNotNull((Object)cache.getCachedSnapshot(key3));
        Assert.assertNull((Object)cache.getCachedSnapshot(key1));
    }
}

