/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataPortDelegate;
import org.apache.cayenne.access.util.DoNothingOperationObserver;
import org.apache.cayenne.access.util.IteratedSelectObserver;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

@Deprecated
public class DataPort {
    public static final int INSERT_BATCH_SIZE = 1000;
    protected DataNode sourceNode;
    protected DataNode destinationNode;
    protected Collection entities;
    protected boolean cleaningDestination;
    protected DataPortDelegate delegate;
    protected int insertBatchSize;

    public DataPort() {
        this.insertBatchSize = 1000;
    }

    public DataPort(DataPortDelegate delegate) {
        this.delegate = delegate;
    }

    public void execute() throws CayenneException {
        if (this.sourceNode == null) {
            throw new CayenneException("Can't port data, source node is null.", new Object[0]);
        }
        if (this.destinationNode == null) {
            throw new CayenneException("Can't port data, destination node is null.", new Object[0]);
        }
        if (this.sourceNode == this.destinationNode) {
            throw new CayenneException("Can't port data, source and target nodes are the same.", new Object[0]);
        }
        if (this.entities == null || this.entities.isEmpty()) {
            return;
        }
        ArrayList<DbEntity> sorted = new ArrayList<DbEntity>(this.entities);
        AshwoodEntitySorter sorter = new AshwoodEntitySorter();
        sorter.setEntityResolver(new EntityResolver(this.destinationNode.getDataMaps()));
        sorter.sortDbEntities(sorted, false);
        if (this.cleaningDestination) {
            ArrayList<DbEntity> entitiesInDeleteOrder = new ArrayList<DbEntity>(sorted.size());
            entitiesInDeleteOrder.addAll(sorted);
            Collections.reverse(entitiesInDeleteOrder);
            this.processDelete(entitiesInDeleteOrder);
        }
        this.processInsert(sorted);
    }

    protected void processDelete(List entities) {
        if (this.delegate != null) {
            entities = this.delegate.willCleanData(this, entities);
        }
        if (entities == null || entities.isEmpty()) {
            return;
        }
        for (DbEntity entity : entities) {
            Query query = new SQLTemplate(entity, "DELETE FROM " + entity.getFullyQualifiedName());
            if (this.delegate != null) {
                query = this.delegate.willCleanData(this, entity, query);
            }
            final int[] count = new int[]{-1};
            DoNothingOperationObserver observer = new DoNothingOperationObserver(){

                @Override
                public void nextCount(Query query, int resultCount) {
                    count[0] = resultCount;
                }
            };
            this.destinationNode.performQueries(Collections.singletonList(query), observer);
            if (this.delegate == null) continue;
            this.delegate.didCleanData(this, entity, count[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInsert(List entities) throws CayenneException {
        if (this.delegate != null) {
            entities = this.delegate.willCleanData(this, entities);
        }
        if (entities == null || entities.isEmpty()) {
            return;
        }
        IteratedSelectObserver observer = new IteratedSelectObserver();
        DoNothingOperationObserver insertObserver = new DoNothingOperationObserver();
        for (DbEntity entity : entities) {
            SelectQuery select = new SelectQuery(entity);
            select.setFetchingDataRows(true);
            SelectQuery query = this.delegate != null ? this.delegate.willPortEntity(this, entity, select) : select;
            this.sourceNode.performQueries(Collections.singletonList(query), observer);
            ResultIterator result = observer.getResultIterator();
            InsertBatchQuery insert = new InsertBatchQuery(entity, 1000);
            try {
                int batchSize;
                int currentRow = 0;
                int n = batchSize = this.insertBatchSize > 0 ? this.insertBatchSize : 1000;
                while (result.hasNextRow()) {
                    if (this.insertBatchSize > 0 && currentRow > 0 && currentRow % this.insertBatchSize == 0) {
                        this.destinationNode.performQueries(Collections.singletonList(insert), insertObserver);
                        insert = new InsertBatchQuery(entity, batchSize);
                    }
                    ++currentRow;
                    DataRow nextRow = (DataRow)result.nextRow();
                    insert.add(nextRow);
                }
                if (insert.getRows().size() > 0) {
                    this.destinationNode.performQueries(Collections.singletonList(insert), insertObserver);
                }
                if (this.delegate == null) continue;
                this.delegate.didPortEntity(this, entity, currentRow);
            }
            finally {
                result.close();
            }
        }
    }

    public Collection getEntities() {
        return this.entities;
    }

    public DataNode getSourceNode() {
        return this.sourceNode;
    }

    public DataNode getDestinationNode() {
        return this.destinationNode;
    }

    public void setEntities(Collection entities) {
        this.entities = entities;
    }

    public void setSourceNode(DataNode sourceNode) {
        this.sourceNode = sourceNode;
    }

    public void setDestinationNode(DataNode destinationNode) {
        this.destinationNode = destinationNode;
    }

    public DataPortDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(DataPortDelegate delegate) {
        this.delegate = delegate;
    }

    public boolean isCleaningDestination() {
        return this.cleaningDestination;
    }

    public void setCleaningDestination(boolean cleaningDestination) {
        this.cleaningDestination = cleaningDestination;
    }

    public int getInsertBatchSize() {
        return this.insertBatchSize;
    }

    public void setInsertBatchSize(int insertBatchSize) {
        this.insertBatchSize = insertBatchSize;
    }
}

