/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextSelectQuerySplitAliasesIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"});
    }

    private void createTwoArtistsTwoPaintingsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "AA"});
        this.tArtist.insert(new Object[]{2, "BB"});
        this.tPainting.insert(new Object[]{1, 1, "X"});
        this.tPainting.insert(new Object[]{2, 2, "Y"});
    }

    private void createTwoArtistsThreePaintingsDataSet() throws Exception {
        this.createTwoArtistsTwoPaintingsDataSet();
        this.tPainting.insert(new Object[]{3, 2, "X"});
    }

    @Test
    public void testAliasPathSplits_SinglePath() throws Exception {
        this.createTwoArtistsTwoPaintingsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.andQualifier(ExpressionFactory.matchExp("p.paintingTitle", "X"));
        query.aliasPathSplits("paintingArray", "p");
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"AA", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testAliasPathSplits_SplitJoin() throws Exception {
        this.createTwoArtistsThreePaintingsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.andQualifier(ExpressionFactory.matchExp("p1.paintingTitle", "X"));
        query.andQualifier(ExpressionFactory.matchExp("p2.paintingTitle", "Y"));
        query.aliasPathSplits("paintingArray", "p1", "p2");
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"BB", (Object)((Artist)artists.get(0)).getArtistName());
    }
}

