/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Date;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.MockDataContextDelegate;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextDelegateSharedCacheIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;
    private Artist artist;

    @Before
    public void setUp() throws Exception {
        this.artist = (Artist)this.context.newObject("Artist");
        this.artist.setArtistName("version1");
        this.artist.setDateOfBirth(new Date());
        this.context.commitChanges();
    }

    @Test
    public void testShouldMergeChanges() throws Exception {
        final boolean[] methodInvoked = new boolean[1];
        MockDataContextDelegate delegate = new MockDataContextDelegate(){

            @Override
            public boolean shouldMergeChanges(DataObject object, DataRow snapshotInStore) {
                methodInvoked[0] = true;
                return true;
            }
        };
        Artist altArtist = this.context1.localObject(this.artist);
        Assert.assertNotNull((Object)altArtist);
        Assert.assertNotSame((Object)altArtist, (Object)this.artist);
        Assert.assertEquals((Object)this.artist.getArtistName(), (Object)altArtist.getArtistName());
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        this.context1.setDelegate(delegate);
        this.artist.setArtistName("version2");
        this.context.commitChanges();
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertTrue((String)"Delegate was not consulted", (boolean)methodInvoked[0]);
            }
        };
        helper.runTest(3000L);
    }

    @Test
    public void testBlockedShouldMergeChanges() throws Exception {
        String oldName = this.artist.getArtistName();
        MockDataContextDelegate delegate = new MockDataContextDelegate(){

            @Override
            public boolean shouldMergeChanges(DataObject object, DataRow snapshotInStore) {
                return false;
            }
        };
        this.context1.setDelegate(delegate);
        Artist altArtist = this.context1.localObject(this.artist);
        Assert.assertNotNull((Object)altArtist);
        Assert.assertFalse((altArtist == this.artist ? 1 : 0) != 0);
        Assert.assertEquals((Object)oldName, (Object)altArtist.getArtistName());
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        this.artist.setArtistName("version2");
        this.context.commitChanges();
        Assert.assertEquals((Object)oldName, (Object)altArtist.getArtistName());
    }

    @Test
    public void testShouldProcessDeleteOnExternalChange() throws Exception {
        final boolean[] methodInvoked = new boolean[1];
        MockDataContextDelegate delegate = new MockDataContextDelegate(){

            @Override
            public boolean shouldProcessDelete(DataObject object) {
                methodInvoked[0] = true;
                return true;
            }
        };
        this.context1.setDelegate(delegate);
        Artist altArtist = this.context1.localObject(this.artist);
        Assert.assertNotNull((Object)altArtist);
        Assert.assertFalse((altArtist == this.artist ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.artist.getArtistName(), (Object)altArtist.getArtistName());
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        this.context.deleteObjects(this.artist);
        this.context.commitChanges();
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertTrue((String)"Delegate was not consulted", (boolean)methodInvoked[0]);
            }
        };
        helper.runTest(3000L);
    }

    @Test
    public void testBlockShouldProcessDeleteOnExternalChange() throws Exception {
        final boolean[] methodInvoked = new boolean[1];
        MockDataContextDelegate delegate = new MockDataContextDelegate(){

            @Override
            public boolean shouldProcessDelete(DataObject object) {
                methodInvoked[0] = true;
                return false;
            }
        };
        this.context1.setDelegate(delegate);
        Artist altArtist = this.context1.localObject(this.artist);
        Assert.assertNotNull((Object)altArtist);
        Assert.assertFalse((altArtist == this.artist ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.artist.getArtistName(), (Object)altArtist.getArtistName());
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        this.context.deleteObjects(this.artist);
        this.context.commitChanges();
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertTrue((String)"Delegate was not consulted", (boolean)methodInvoked[0]);
            }
        };
        helper.runTest(3000L);
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        Assert.assertNotNull((Object)altArtist.getObjectContext());
    }
}

