/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.ExpressionParameter;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SelectQueryTest {
    private SelectQuery<?> query;

    @Before
    public void before() {
        this.query = new SelectQuery();
    }

    @Test
    public void testAddPrefetch() {
        Assert.assertNull((Object)this.query.getPrefetchTree());
        this.query.addPrefetch("a.b.c");
        Assert.assertNotNull((Object)this.query.getPrefetchTree());
        Assert.assertEquals((long)1L, (long)this.query.getPrefetchTree().nonPhantomNodes().size());
        Assert.assertNotNull((Object)this.query.getPrefetchTree().getNode("a.b.c"));
    }

    @Test
    public void testAddPrefetchDuplicates() {
        this.query.addPrefetch("a.b.c");
        this.query.addPrefetch("a.b.c");
        Assert.assertEquals((long)1L, (long)this.query.getPrefetchTree().nonPhantomNodes().size());
    }

    @Test
    public void testClearPrefetches() {
        this.query.addPrefetch("abc");
        this.query.addPrefetch("xyz");
        Assert.assertNotNull((Object)this.query.getPrefetchTree());
        this.query.clearPrefetches();
        Assert.assertNull((Object)this.query.getPrefetchTree());
    }

    @Test
    public void testPageSize() throws Exception {
        this.query.setPageSize(10);
        Assert.assertEquals((long)10L, (long)this.query.getPageSize());
    }

    @Test
    public void testAddOrdering1() throws Exception {
        Ordering ord = new Ordering();
        this.query.addOrdering(ord);
        Assert.assertEquals((long)1L, (long)this.query.getOrderings().size());
        Assert.assertSame((Object)ord, (Object)this.query.getOrderings().get(0));
    }

    @Test
    public void testAddOrdering2() throws Exception {
        String path = "a.b.c";
        this.query.addOrdering(path, SortOrder.DESCENDING);
        Assert.assertEquals((long)1L, (long)this.query.getOrderings().size());
        Ordering ord = this.query.getOrderings().get(0);
        Assert.assertEquals((Object)path, (Object)ord.getSortSpec().getOperand(0));
        Assert.assertEquals((Object)false, (Object)ord.isAscending());
    }

    @Test
    public void testDistinct() throws Exception {
        Assert.assertFalse((boolean)this.query.isDistinct());
        this.query.setDistinct(true);
        Assert.assertTrue((boolean)this.query.isDistinct());
    }

    @Test
    public void testQueryWithParams1() {
        this.query.setRoot(Artist.class);
        this.query.setDistinct(true);
        SelectQuery<?> q1 = this.query.queryWithParameters(new HashMap(), true);
        Assert.assertSame((Object)this.query.getRoot(), (Object)q1.getRoot());
        Assert.assertEquals((Object)this.query.isDistinct(), (Object)q1.isDistinct());
        Assert.assertNull((Object)q1.getQualifier());
    }

    @Test
    public void testQueryWithParams2() throws Exception {
        this.query.setRoot(Artist.class);
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(ExpressionFactory.matchExp("k1", (Object)new ExpressionParameter("test1")));
        list.add(ExpressionFactory.matchExp("k2", (Object)new ExpressionParameter("test2")));
        list.add(ExpressionFactory.matchExp("k3", (Object)new ExpressionParameter("test3")));
        list.add(ExpressionFactory.matchExp("k4", (Object)new ExpressionParameter("test4")));
        this.query.setQualifier(ExpressionFactory.joinExp(1, list));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test2", "abc");
        params.put("test3", "xyz");
        SelectQuery<?> q1 = this.query.queryWithParameters(params, true);
        Assert.assertSame((Object)this.query.getRoot(), (Object)q1.getRoot());
        Assert.assertNotNull((Object)q1.getQualifier());
        Assert.assertTrue((q1.getQualifier() != this.query.getQualifier() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryWithParamsSkipName() {
        this.query.setRoot(Artist.class);
        this.query.setDistinct(true);
        this.query.setName("name");
        SelectQuery<?> q1 = this.query.queryWithParameters(Collections.emptyMap());
        Assert.assertEquals((Object)"name", (Object)this.query.getName());
        Assert.assertNull((Object)q1.getName());
    }

    @Test
    public void testAndQualifier() {
        Assert.assertNull((Object)this.query.getQualifier());
        Expression e1 = ExpressionFactory.expressionOfType(3);
        this.query.andQualifier(e1);
        Assert.assertSame((Object)e1, (Object)this.query.getQualifier());
        Expression e2 = ExpressionFactory.expressionOfType(4);
        this.query.andQualifier(e2);
        Assert.assertEquals((long)0L, (long)this.query.getQualifier().getType());
    }

    @Test
    public void testOrQualifier() {
        Assert.assertNull((Object)this.query.getQualifier());
        Expression e1 = ExpressionFactory.expressionOfType(3);
        this.query.orQualifier(e1);
        Assert.assertSame((Object)e1, (Object)this.query.getQualifier());
        Expression e2 = ExpressionFactory.expressionOfType(4);
        this.query.orQualifier(e2);
        Assert.assertEquals((long)1L, (long)this.query.getQualifier().getType());
    }

    @Test
    public void testSetQualifier() {
        Assert.assertNull((Object)this.query.getQualifier());
        Expression qual = ExpressionFactory.expressionOfType(0);
        this.query.setQualifier(qual);
        Assert.assertNotNull((Object)this.query.getQualifier());
        Assert.assertSame((Object)qual, (Object)this.query.getQualifier());
    }
}

