/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SQLExec;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SQLExecIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Test
    public void test_DataMapNameRoot() throws Exception {
        int inserted = SQLExec.query("testmap", "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (1, 'a')").update(this.context);
        Assert.assertEquals((long)1L, (long)inserted);
    }

    @Test
    public void test_DefaultRoot() throws Exception {
        int inserted = SQLExec.query("INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (1, 'a')").update(this.context);
        Assert.assertEquals((long)1L, (long)inserted);
    }

    @Test
    public void test_ParamsArray_Single() throws Exception {
        int inserted = SQLExec.query("INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (1, #bind($name))").paramsArray("a3").update(this.context);
        Assert.assertEquals((long)1L, (long)inserted);
        Assert.assertEquals((Object)"a3", (Object)this.dbHelper.getString("ARTIST", "ARTIST_NAME").trim());
    }

    @Test
    public void test_ParamsArray_Multiple() throws Exception {
        int inserted = SQLExec.query("INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME) VALUES (#bind($id), #bind($name))").paramsArray(55, "a3").update(this.context);
        Assert.assertEquals((long)1L, (long)inserted);
        Assert.assertEquals((long)55L, (long)this.dbHelper.getLong("ARTIST", "ARTIST_ID"));
        Assert.assertEquals((Object)"a3", (Object)this.dbHelper.getString("ARTIST", "ARTIST_NAME").trim());
    }
}

