/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTAsterisk;
import org.apache.cayenne.exp.parser.ASTAvg;
import org.apache.cayenne.exp.parser.ASTCount;
import org.apache.cayenne.exp.parser.ASTMax;
import org.apache.cayenne.exp.parser.ASTMin;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTSum;
import org.junit.Assert;
import org.junit.Test;

public class ASTAggregateTest {
    @Test
    public void testAvgConstruct() throws Exception {
        ASTAvg avg = new ASTAvg(null);
        Assert.assertEquals((Object)"AVG", (Object)avg.getFunctionName());
    }

    @Test(expected=ExpressionException.class)
    public void testAvgEvaluate() throws Exception {
        ASTAvg avg = new ASTAvg(null);
        avg.evaluate(new Object());
    }

    @Test
    public void testAvgParse() throws Exception {
        String expressionString = "avg(artistName)";
        Expression exp = ExpressionFactory.exp(expressionString, new Object[0]);
        Assert.assertTrue((boolean)(exp instanceof ASTAvg));
        Assert.assertEquals((long)1L, (long)exp.getOperandCount());
        Assert.assertTrue((boolean)(exp.getOperand(0) instanceof ASTObjPath));
        Assert.assertEquals((Object)expressionString, (Object)exp.toString());
    }

    @Test
    public void testCountConstruct() throws Exception {
        ASTCount count = new ASTCount();
        Assert.assertEquals((Object)"COUNT", (Object)count.getFunctionName());
    }

    @Test
    public void testCountExpParse() throws Exception {
        String expressionString = "count(artistName)";
        Expression exp = ExpressionFactory.exp(expressionString, new Object[0]);
        Assert.assertTrue((boolean)(exp instanceof ASTCount));
        Assert.assertEquals((long)1L, (long)exp.getOperandCount());
        Assert.assertTrue((boolean)(exp.getOperand(0) instanceof ASTObjPath));
        Assert.assertEquals((Object)expressionString, (Object)exp.toString());
    }

    @Test
    public void testCountAsteriskParse() throws Exception {
        String expressionString = "count(*)";
        Expression exp = ExpressionFactory.exp(expressionString, new Object[0]);
        Assert.assertTrue((boolean)(exp instanceof ASTCount));
        Assert.assertEquals((long)1L, (long)exp.getOperandCount());
        Assert.assertTrue((boolean)(exp.getOperand(0) instanceof ASTAsterisk));
        Assert.assertEquals((Object)expressionString, (Object)exp.toString());
    }

    @Test
    public void testMinConstruct() throws Exception {
        ASTMin min = new ASTMin(null);
        Assert.assertEquals((Object)"MIN", (Object)min.getFunctionName());
    }

    @Test
    public void testMinParse() throws Exception {
        String expressionString = "min(artistName)";
        Expression exp = ExpressionFactory.exp(expressionString, new Object[0]);
        Assert.assertTrue((boolean)(exp instanceof ASTMin));
        Assert.assertEquals((long)1L, (long)exp.getOperandCount());
        Assert.assertTrue((boolean)(exp.getOperand(0) instanceof ASTObjPath));
        Assert.assertEquals((Object)expressionString, (Object)exp.toString());
    }

    @Test
    public void testMaxConstruct() throws Exception {
        ASTMax max = new ASTMax(null);
        Assert.assertEquals((Object)"MAX", (Object)max.getFunctionName());
    }

    @Test
    public void testMaxParse() throws Exception {
        String expressionString = "max(artistName)";
        Expression exp = ExpressionFactory.exp(expressionString, new Object[0]);
        Assert.assertTrue((boolean)(exp instanceof ASTMax));
        Assert.assertEquals((long)1L, (long)exp.getOperandCount());
        Assert.assertTrue((boolean)(exp.getOperand(0) instanceof ASTObjPath));
        Assert.assertEquals((Object)expressionString, (Object)exp.toString());
    }

    @Test
    public void testSumConstruct() throws Exception {
        ASTSum sum = new ASTSum(null);
        Assert.assertEquals((Object)"SUM", (Object)sum.getFunctionName());
    }

    @Test
    public void testSumParse() throws Exception {
        String expressionString = "sum(artistName)";
        Expression exp = ExpressionFactory.exp(expressionString, new Object[0]);
        Assert.assertTrue((boolean)(exp instanceof ASTSum));
        Assert.assertEquals((long)1L, (long)exp.getOperandCount());
        Assert.assertTrue((boolean)(exp.getOperand(0) instanceof ASTObjPath));
        Assert.assertEquals((Object)expressionString, (Object)exp.toString());
    }
}

