/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.log.NoopJdbcEventLogger;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-testmap.xml")
public class AutoAdapterIT
extends ServerCase {
    @Inject
    private DataNode dataNode;

    @Test
    public void testGetAdapter_Proxy() throws Exception {
        Provider adapterProvider = (Provider)Mockito.mock(Provider.class);
        Mockito.when((Object)adapterProvider.get()).thenReturn((Object)this.dataNode.getAdapter());
        AutoAdapter adapter = new AutoAdapter((Provider<DbAdapter>)adapterProvider, NoopJdbcEventLogger.getInstance());
        DbAdapter detected = adapter.getAdapter();
        Assert.assertSame((Object)this.dataNode.getAdapter(), (Object)detected);
    }

    @Test
    public void testCreateSQLTemplateAction() {
        Provider adapterProvider = (Provider)Mockito.mock(Provider.class);
        Mockito.when((Object)adapterProvider.get()).thenReturn((Object)this.dataNode.getAdapter());
        AutoAdapter autoAdapter = new AutoAdapter((Provider<DbAdapter>)adapterProvider, NoopJdbcEventLogger.getInstance());
        SQLTemplateAction action = (SQLTemplateAction)autoAdapter.getAction(new SQLTemplate(Artist.class, "select * from artist"), this.dataNode);
        Assert.assertNotNull((Object)action.getAdapter());
        Assert.assertFalse((boolean)(action.getAdapter() instanceof AutoAdapter));
        Assert.assertSame((Object)this.dataNode.getAdapter(), (Object)action.getAdapter());
    }
}

