/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.inheritance_flat.Group;
import org.apache.cayenne.testdo.inheritance_flat.Role;
import org.apache.cayenne.testdo.inheritance_flat.User;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-inheritance-single-table1.xml")
public class SingleTableInheritance1IT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testGroupActions() throws Exception {
        User user = this.context.newObject(User.class);
        user.setName("test_user");
        Group group1 = this.context.newObject(Group.class);
        group1.setName("test_group1");
        Group group2 = this.context.newObject(Group.class);
        group2.setName("test_group2");
        group1.addToGroupMembers(user);
        group2.addToGroupMembers(group1);
        group2.getObjectContext().commitChanges();
        group1.removeFromGroupMembers(user);
        Expression exp = ExpressionFactory.matchExp(Role.ROLE_GROUPS.getName(), (Object)group2);
        SelectQuery<Group> query = new SelectQuery<Group>(Group.class, exp);
        this.context.performQuery(query);
        this.context.commitChanges();
        this.context.deleteObjects(group1);
        this.context.deleteObjects(group2);
        this.context.deleteObjects(user);
        this.context.commitChanges();
    }

    @Test
    public void testFlattenedNullifyNullifyDeleteRules() throws Exception {
        User user = this.context.newObject(User.class);
        user.setName("test_user");
        Group group = this.context.newObject(Group.class);
        group.setName("test_group");
        group.addToGroupMembers(user);
        this.context.commitChanges();
        this.context.deleteObjects(user);
        Assert.assertTrue((boolean)group.getGroupMembers().isEmpty());
        this.context.commitChanges();
        this.context.deleteObjects(group);
        this.context.commitChanges();
    }
}

