/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.velocity;

import java.util.Collections;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.velocity.VelocitySQLTemplateProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VelocitySQLTemplateProcessor_SelectTest {
    private VelocitySQLTemplateProcessor processor;

    @Before
    public void before() {
        this.processor = new VelocitySQLTemplateProcessor();
    }

    @Test
    public void testProcessTemplateUnchanged() throws Exception {
        String sqlTemplate = "SELECT * FROM ME";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)sqlTemplate, (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
        Assert.assertEquals((long)0L, (long)compiled.getResultColumns().length);
    }

    @Test
    public void testProcessSelectTemplate1() throws Exception {
        String sqlTemplate = "SELECT #result('A') FROM ME";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)"SELECT A FROM ME", (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
        Assert.assertEquals((long)1L, (long)compiled.getResultColumns().length);
        Assert.assertEquals((Object)"A", (Object)compiled.getResultColumns()[0].getName());
        Assert.assertNull((Object)compiled.getResultColumns()[0].getJavaClass());
    }

    @Test
    public void testProcessSelectTemplate2() throws Exception {
        String sqlTemplate = "SELECT #result('A' 'String') FROM ME";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)"SELECT A FROM ME", (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
        Assert.assertEquals((long)1L, (long)compiled.getResultColumns().length);
        Assert.assertEquals((Object)"A", (Object)compiled.getResultColumns()[0].getName());
        Assert.assertEquals((Object)"java.lang.String", (Object)compiled.getResultColumns()[0].getJavaClass());
    }

    @Test
    public void testProcessSelectTemplate3() throws Exception {
        String sqlTemplate = "SELECT #result('A' 'String' 'B') FROM ME";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)"SELECT A AS B FROM ME", (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
        Assert.assertEquals((long)1L, (long)compiled.getResultColumns().length);
        ColumnDescriptor column = compiled.getResultColumns()[0];
        Assert.assertEquals((Object)"A", (Object)column.getName());
        Assert.assertEquals((Object)"B", (Object)column.getDataRowKey());
        Assert.assertEquals((Object)"java.lang.String", (Object)column.getJavaClass());
    }

    @Test
    public void testProcessSelectTemplate4() throws Exception {
        String sqlTemplate = "SELECT #result('A'), #result('B'), #result('C') FROM ME";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)"SELECT A, B, C FROM ME", (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
        Assert.assertEquals((long)3L, (long)compiled.getResultColumns().length);
        Assert.assertEquals((Object)"A", (Object)compiled.getResultColumns()[0].getName());
        Assert.assertEquals((Object)"B", (Object)compiled.getResultColumns()[1].getName());
        Assert.assertEquals((Object)"C", (Object)compiled.getResultColumns()[2].getName());
    }
}

