/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.UnitTestDomain;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataDomainProvider;
import org.apache.cayenne.configuration.server.DataNodeFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.unit.UnitDbAdapter;

class ServerCaseDataDomainProvider
extends DataDomainProvider {
    @Inject
    private UnitDbAdapter unitDbAdapter;
    @Inject
    protected DataNodeFactory dataNodeFactory;

    ServerCaseDataDomainProvider() {
    }

    @Override
    protected DataDomain createDataDomain(String name) {
        return new UnitTestDomain(name);
    }

    @Override
    protected DataDomain createAndInitDataDomain() throws Exception {
        DataDomain domain = super.createAndInitDataDomain();
        DataNode node = null;
        for (DataMap dataMap : domain.getDataMaps()) {
            DataNodeDescriptor descriptor = new DataNodeDescriptor(dataMap.getName());
            node = this.dataNodeFactory.createDataNode(descriptor);
            node.addDataMap(dataMap);
            for (Procedure proc : dataMap.getProcedures()) {
                this.unitDbAdapter.tweakProcedure(proc);
            }
            domain.addNode(node);
        }
        if (domain.getDataMaps().size() == 1) {
            domain.setDefaultNode(node);
        }
        return domain;
    }
}

