/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.commons.collections.ExtendedProperties;

class ConnectionProperties {
    static final int MIN_CONNECTIONS = 1;
    static final int MAX_CONNECTIONS = 2;
    private static final String ADAPTER_KEY = "adapter";
    private static final String ADAPTER20_KEY = "cayenne.adapter";
    private static final String USER_NAME_KEY = "jdbc.username";
    private static final String PASSWORD_KEY = "jdbc.password";
    private static final String URL_KEY = "jdbc.url";
    private static final String DRIVER_KEY = "jdbc.driver";
    private Map<String, DataSourceInfo> connectionInfos = new HashMap<String, DataSourceInfo>();

    ConnectionProperties(ExtendedProperties props) {
        for (String name : this.extractNames(props)) {
            DataSourceInfo dsi = this.buildDataSourceInfo(props.subset(name));
            this.connectionInfos.put(name, dsi);
        }
    }

    int size() {
        return this.connectionInfos.size();
    }

    DataSourceInfo getConnection(String name) {
        return this.connectionInfos.get(name);
    }

    private DataSourceInfo buildDataSourceInfo(ExtendedProperties props) {
        DataSourceInfo dsi = new DataSourceInfo();
        String adapter = props.getString(ADAPTER_KEY);
        if (adapter == null) {
            adapter = props.getString(ADAPTER20_KEY);
        }
        dsi.setAdapterClassName(adapter);
        dsi.setUserName(props.getString(USER_NAME_KEY));
        dsi.setPassword(props.getString(PASSWORD_KEY));
        dsi.setDataSourceUrl(props.getString(URL_KEY));
        dsi.setJdbcDriver(props.getString(DRIVER_KEY));
        dsi.setMinConnections(1);
        dsi.setMaxConnections(2);
        return dsi;
    }

    private List<String> extractNames(ExtendedProperties props) {
        Iterator it = props.getKeys();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            String name;
            String key = (String)it.next();
            int dotInd = key.indexOf(46);
            if (dotInd <= 0 || dotInd >= key.length() || list.contains(name = key.substring(0, dotInd))) continue;
            list.add(name);
        }
        return list;
    }
}

