/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.CayenneTransaction;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class TransactionThreadIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private JdbcEventLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadConnectionReuseOnSelect() throws Exception {
        CayenneTransaction t = new CayenneTransaction(this.logger);
        BaseTransaction.bindThreadTransaction(t);
        try {
            SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
            this.context.performQuery(q1);
            Assert.assertEquals((long)1L, (long)t.getConnections().size());
            SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class);
            this.context.performQuery(q2);
            Assert.assertEquals((long)1L, (long)t.getConnections().size());
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
            t.commit();
        }
    }
}

