/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.annotation.PostRemove;
import org.apache.cayenne.annotation.PostUpdate;
import org.apache.cayenne.annotation.PrePersist;
import org.apache.cayenne.annotation.PreRemove;
import org.apache.cayenne.annotation.PreUpdate;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.testdo.lifecycle_callbacks_order.Lifecycle;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-lifecycle-callbacks-order.xml")
public class LifecycleCallbackOrderIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testLifecycleCallbackOrder() {
        LifecycleCallbackRegistry registry = new LifecycleCallbackRegistry(this.context.getEntityResolver());
        this.context.getEntityResolver().setCallbackRegistry(registry);
        LifecycleEventListener eventListener = new LifecycleEventListener();
        registry.addListener(eventListener);
        Lifecycle lifecycle = this.context.newObject(Lifecycle.class);
        this.context.commitChanges();
        Assert.assertEquals((Object)"validateForInsert;PrePersist;PostPersist;", (Object)lifecycle.getCallbackBufferValueAndReset());
        lifecycle.setName("CallbackOrderTest");
        this.context.commitChanges();
        Assert.assertEquals((Object)"validateForUpdate;PreUpdate;PostUpdate;", (Object)lifecycle.getCallbackBufferValueAndReset());
        this.context.deleteObject(lifecycle);
        Assert.assertEquals((Object)"PreRemove;", (Object)lifecycle.getCallbackBuffer().toString());
        this.context.commitChanges();
        Assert.assertEquals((Object)"PreRemove;validateForDelete;PostRemove;", (Object)lifecycle.getCallbackBufferValueAndReset());
    }

    class LifecycleEventListener {
        LifecycleEventListener() {
        }

        @PrePersist(value={Lifecycle.class})
        void prePersist(Lifecycle lifecycle) {
            lifecycle.getCallbackBuffer().append("PrePersist;");
        }

        @PostPersist(value={Lifecycle.class})
        void postPersist(Lifecycle lifecycle) {
            lifecycle.getCallbackBuffer().append("PostPersist;");
        }

        @PreUpdate(value={Lifecycle.class})
        void preUpdate(Lifecycle lifecycle) {
            lifecycle.getCallbackBuffer().append("PreUpdate;");
        }

        @PostUpdate(value={Lifecycle.class})
        void postUpdate(Lifecycle lifecycle) {
            lifecycle.getCallbackBuffer().append("PostUpdate;");
        }

        @PreRemove(value={Lifecycle.class})
        void preRemove(Lifecycle lifecycle) {
            lifecycle.getCallbackBuffer().append("PreRemove;");
        }

        @PostRemove(value={Lifecycle.class})
        void postRemove(Lifecycle lifecycle) {
            lifecycle.getCallbackBuffer().append("PostRemove;");
        }
    }
}

