/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SQLTemplateIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    @Test
    public void testSQLTemplateForDataMap() {
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q1 = new SQLTemplate(testDataMap, "SELECT * FROM ARTIST", true);
        List result = this.context.performQuery(q1);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testSQLTemplateForDataMapWithInsert() {
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        String sql = "INSERT INTO ARTIST VALUES (15, 'Surikov', null)";
        SQLTemplate q1 = new SQLTemplate(testDataMap, sql, true);
        this.context.performNonSelectingQuery(q1);
        SQLTemplate q2 = new SQLTemplate(testDataMap, "SELECT * FROM ARTIST", true);
        List result = this.context.performQuery(q2);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testSQLTemplateForDataMapWithInsertException() {
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        String sql = "INSERT INTO ARTIST VALUES (15, 'Surikov', null)";
        SQLTemplate q1 = new SQLTemplate(testDataMap, sql, true);
        this.context.performNonSelectingQuery(q1);
        SQLTemplate q2 = new SQLTemplate(testDataMap, "SELECT * FROM ARTIST", false);
        boolean gotRuntimeException = false;
        try {
            this.context.performQuery(q2);
        }
        catch (CayenneRuntimeException e) {
            gotRuntimeException = true;
        }
        Assert.assertTrue((String)"If fetchingDataRows is false and ObjectEntity not set, should be thrown exception", (boolean)gotRuntimeException);
    }

    @Test
    public void testSQLTemplate_PositionalParams() throws SQLException {
        String sql = "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE) VALUES ($b, '$n', #bind($c 'INTEGER'))";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.setParamsArray(76, "The Fiddler", 10005);
        this.context.performNonSelectingQuery(q1);
        Assert.assertEquals((Object)"The Fiddler", (Object)this.tPainting.getString("PAINTING_TITLE"));
        Assert.assertEquals((long)76L, (long)this.tPainting.getInt("PAINTING_ID"));
        Assert.assertEquals((double)10005.0, (double)this.tPainting.getDouble("ESTIMATED_PRICE"), (double)0.001);
    }

    @Test
    public void testSQLTemplate_PositionalParams_RepeatingVars() throws SQLException {
        String sql = "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE) VALUES ($b, '$n', #bind($b 'INTEGER'))";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.setParamsArray(11, "The Fiddler");
        this.context.performNonSelectingQuery(q1);
        Assert.assertEquals((Object)"The Fiddler", (Object)this.tPainting.getString("PAINTING_TITLE"));
        Assert.assertEquals((long)11L, (long)this.tPainting.getInt("PAINTING_ID"));
        Assert.assertEquals((double)11.0, (double)this.tPainting.getDouble("ESTIMATED_PRICE"), (double)0.001);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testSQLTemplate_PositionalParams_ToFewParams() throws SQLException {
        String sql = "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE) VALUES ($b, '$n', #bind($c 'INTEGER'))";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.setParamsArray(11, "The Fiddler");
        this.context.performNonSelectingQuery(q1);
    }

    @Test
    public void testSQLTemplate_PositionalParams_ToManyParams() throws SQLException {
        String sql = "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE) VALUES ($b, '$n', #bind($b 'INTEGER'))";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.setParamsArray(11, "The Fiddler", 2345, 333);
        try {
            this.context.performNonSelectingQuery(q1);
            Assert.fail((String)"Exception not thrown on parameter length mismatch");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }
}

