/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.compound.CompoundFkTestEntity;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class QueryWithCompoundJoinIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tCompoundPk;
    private TableHelper tCompoundFk;

    @Before
    public void setUp() throws Exception {
        this.tCompoundPk = new TableHelper(this.dbHelper, "COMPOUND_PK_TEST");
        this.tCompoundPk.setColumns(new String[]{"KEY1", "KEY2", "NAME"});
        this.tCompoundFk = new TableHelper(this.dbHelper, "COMPOUND_FK_TEST");
        this.tCompoundFk.setColumns(new String[]{"F_KEY1", "F_KEY2", "NAME", "PKEY"});
        this.createDataSet();
    }

    private void createDataSet() throws Exception {
        this.tCompoundPk.insert(new Object[]{"a", "b", "abc"});
        this.tCompoundPk.insert(new Object[]{"c", "d", "cde"});
        this.tCompoundFk.insert(new Object[]{"a", "b", "test", 1});
        this.tCompoundFk.insert(new Object[]{"c", "d", "nottest", 2});
    }

    @Test
    public void testEJBQLCompoundJoin() throws Exception {
        EJBQLQuery query = new EJBQLQuery("select f from CompoundFkTestEntity f inner join f.toCompoundPk p where p.name like 'a%'");
        List res = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertTrue((boolean)(res.get(0) instanceof CompoundFkTestEntity));
        Assert.assertEquals((Object)"test", (Object)((CompoundFkTestEntity)res.get(0)).getName());
    }

    @Test
    public void testObjectSelectCompoundJoin() throws Exception {
        List res = ObjectSelect.query(CompoundFkTestEntity.class).where(CompoundFkTestEntity.TO_COMPOUND_PK.dot(CompoundPkTestEntity.NAME).like("a%")).select(this.context);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((Object)"test", (Object)((CompoundFkTestEntity)res.get(0)).getName());
    }
}

