/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-numeric-types.xml")
public class EJBQLQueryNumericIT
extends ServerCase {
    @Inject
    protected DBHelper dbHelper;
    @Inject
    private ObjectContext context;
    private TableHelper tBigIntegerEntity;

    @Before
    public void setUp() throws Exception {
        this.tBigIntegerEntity = new TableHelper(this.dbHelper, "BIGINTEGER_ENTITY");
        this.tBigIntegerEntity.setColumns(new String[]{"ID", "BIG_INTEGER_FIELD"});
    }

    protected void createBigIntegerEntitiesDataSet() throws Exception {
        this.tBigIntegerEntity.insert(new Object[]{44001, new Long(744073709551715L)});
    }

    @Test
    public void testLongParameter() throws Exception {
        this.createBigIntegerEntitiesDataSet();
        String ejbql = "SELECT bie FROM BigIntegerEntity bie WHERE bie.bigIntegerField > ?1";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter(1, (Object)744073709551615L);
        List result = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testLongLiteral() throws Exception {
        this.createBigIntegerEntitiesDataSet();
        String ejbql = "SELECT bie FROM BigIntegerEntity bie WHERE bie.bigIntegerField > 744073709551615";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List result = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
    }
}

