/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class EntityResolverIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DataContext context;

    @Test
    public void testGetObjEntity() {
        EntityResolver resolver = new EntityResolver(this.runtime.getDataDomain().getDataMaps());
        this.assertIsArtistObjEntity(resolver.getObjEntity("Artist"));
    }

    @Test
    public void testLookupObjEntityByClass() {
        EntityResolver resolver = new EntityResolver(this.runtime.getDataDomain().getDataMaps());
        this.assertIsArtistObjEntity(resolver.getObjEntity(Artist.class));
    }

    @Test
    public void testLookupObjEntityByInstance() {
        EntityResolver resolver = new EntityResolver(this.runtime.getDataDomain().getDataMaps());
        this.assertIsArtistObjEntity(resolver.getObjEntity(new Artist()));
    }

    @Test
    public void testLookupObjEntityByDataobject() {
        EntityResolver resolver = new EntityResolver(this.runtime.getDataDomain().getDataMaps());
        Artist artist = (Artist)this.context.newObject("Artist");
        this.assertIsArtistObjEntity(resolver.getObjEntity(artist));
    }

    @Test
    public void testGetDataMapList() {
        DataMap m1 = new DataMap();
        DataMap m2 = new DataMap();
        ArrayList<DataMap> list = new ArrayList<DataMap>();
        list.add(m1);
        list.add(m2);
        EntityResolver resolver = new EntityResolver(list);
        Collection<DataMap> maps = resolver.getDataMaps();
        Assert.assertNotNull(maps);
        Assert.assertEquals((long)2L, (long)maps.size());
        Assert.assertTrue((boolean)maps.containsAll(list));
    }

    @Test
    public void testAddDataMap() {
        EntityResolver resolver = new EntityResolver();
        Assert.assertEquals((long)0L, (long)resolver.getDataMaps().size());
        Assert.assertNull((Object)resolver.getObjEntity(Object.class));
        DataMap m1 = new DataMap();
        ObjEntity oe1 = new ObjEntity("test");
        oe1.setClassName(Object.class.getName());
        m1.addObjEntity(oe1);
        resolver.addDataMap(m1);
        Assert.assertEquals((long)1L, (long)resolver.getDataMaps().size());
        Assert.assertSame((Object)oe1, (Object)resolver.getObjEntity(Object.class));
        Assert.assertEquals((Object)resolver, (Object)m1.getNamespace());
    }

    @Test
    public void testRemoveDataMap() {
        DataMap m1 = new DataMap();
        ObjEntity oe1 = new ObjEntity("test");
        oe1.setClassName(Object.class.getName());
        m1.addObjEntity(oe1);
        ArrayList<DataMap> list = new ArrayList<DataMap>();
        list.add(m1);
        EntityResolver resolver = new EntityResolver(list);
        Assert.assertEquals((long)1L, (long)resolver.getDataMaps().size());
        Assert.assertSame((Object)oe1, (Object)resolver.getObjEntity(Object.class));
        resolver.removeDataMap(m1);
        Assert.assertEquals((long)0L, (long)resolver.getDataMaps().size());
        Assert.assertNull((Object)resolver.getObjEntity(Object.class));
    }

    @Test
    public void testAddObjEntity() {
        DataMap m1 = new DataMap();
        ObjEntity oe1 = new ObjEntity("test1");
        oe1.setClassName(Object.class.getName());
        m1.addObjEntity(oe1);
        ArrayList<DataMap> list = new ArrayList<DataMap>();
        list.add(m1);
        EntityResolver resolver = new EntityResolver(list);
        Assert.assertSame((Object)oe1, (Object)resolver.getObjEntity(Object.class));
        ObjEntity oe2 = new ObjEntity("test2");
        oe2.setClassName(String.class.getName());
        m1.addObjEntity(oe2);
        Assert.assertSame((Object)oe2, (Object)resolver.getObjEntity(String.class));
    }

    @Test
    public void testGetQuery() {
        DataMap m1 = new DataMap();
        SelectQueryDescriptor q = QueryDescriptor.selectQueryDescriptor();
        q.setName("query1");
        m1.addQueryDescriptor(q);
        EntityResolver resolver = new EntityResolver(Collections.singleton(m1));
        Assert.assertSame((Object)q, (Object)resolver.getQueryDescriptor("query1"));
        Assert.assertNull((Object)resolver.getQueryDescriptor("query2"));
        SelectQueryDescriptor q2 = QueryDescriptor.selectQueryDescriptor();
        q2.setName("query2");
        m1.addQueryDescriptor(q2);
        Assert.assertSame((Object)q2, (Object)resolver.getQueryDescriptor("query2"));
    }

    private void assertIsArtistObjEntity(ObjEntity ae) {
        Assert.assertNotNull((Object)ae);
        Assert.assertEquals((Object)ae, (Object)this.getObjEntity("Artist"));
    }

    private ObjEntity getObjEntity(String objEntityName) {
        for (DataMap map : this.runtime.getDataDomain().getDataMaps()) {
            for (ObjEntity e : map.getObjEntities()) {
                if (!objEntityName.equals(e.getName())) continue;
                return e;
            }
        }
        throw new CayenneRuntimeException("No ObjEntity found: " + objEntityName, new Object[0]);
    }
}

