/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import org.apache.cayenne.exp.parser.ASTGreater;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Painting;
import org.junit.Assert;
import org.junit.Test;

public class ASTGreaterTest {
    @Test
    public void testEvaluate() {
        ASTGreater e = new ASTGreater(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        noMatch.setEstimatedPrice(new BigDecimal(9999));
        Assert.assertFalse((boolean)e.match(noMatch));
        Painting noMatch1 = new Painting();
        noMatch1.setEstimatedPrice(new BigDecimal(10000));
        Assert.assertFalse((boolean)e.match(noMatch1));
        Painting match = new Painting();
        match.setEstimatedPrice(new BigDecimal(10001));
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match));
    }

    @Test
    public void testEvaluate_Null() {
        ASTGreater gtNull = new ASTGreater(new ASTObjPath("estimatedPrice"), null);
        ASTGreater gtNotNull = new ASTGreater(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)gtNull.match(noMatch));
        Assert.assertFalse((boolean)gtNotNull.match(noMatch));
    }
}

