/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Date;
import junit.framework.TestCase;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.exp.parser.ASTConcat;
import org.apache.cayenne.exp.parser.ASTLength;
import org.apache.cayenne.exp.parser.ASTLocate;
import org.apache.cayenne.exp.parser.ASTLower;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ASTSubstring;
import org.apache.cayenne.exp.parser.ASTTrim;
import org.apache.cayenne.exp.parser.ASTUpper;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ASTFunctionCallStringIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    private Artist createArtist(String name) throws Exception {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName(name);
        a1.setDateOfBirth(new Date());
        this.context.commitChanges();
        return a1;
    }

    @Test
    public void testASTTrimInWhere() throws Exception {
        Artist a1 = this.createArtist("  name  ");
        ASTTrim exp = new ASTTrim(Artist.ARTIST_NAME.path());
        Property<String> trimmedName = Property.create("trimmedName", exp, String.class);
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(trimmedName.eq("name")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTUpperInWhere() throws Exception {
        Artist a1 = this.createArtist("name");
        ASTUpper exp = new ASTUpper(Artist.ARTIST_NAME.path());
        Property<String> upperName = Property.create("upperName", exp, String.class);
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(upperName.eq("NAME")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTLowerInWhere() throws Exception {
        Artist a1 = this.createArtist("NAME");
        ASTLower exp = new ASTLower(Artist.ARTIST_NAME.path());
        Property<String> lowerName = Property.create("lowerName", exp, String.class);
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(lowerName.eq("name")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTSubstringInWhere() throws Exception {
        Artist a1 = this.createArtist("1234567890xyz");
        ASTSubstring exp = new ASTSubstring(Artist.ARTIST_NAME.path(), new ASTScalar((Object)2), new ASTScalar((Object)8));
        Property<String> substrName = Property.create("substrName", exp, String.class);
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(substrName.eq("23456789")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTConcat() throws Exception {
        Artist a1 = this.createArtist("Pablo");
        ASTScalar scalar1 = new ASTScalar(" ");
        ASTScalar scalar2 = new ASTScalar("Picasso");
        ASTConcat exp = new ASTConcat(Artist.ARTIST_NAME.path(), scalar1, scalar2);
        Property<String> concatName = Property.create("concatName", exp, String.class);
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(concatName.eq("Pablo Picasso")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTLength() throws Exception {
        Artist a1 = this.createArtist("123456");
        ASTLength exp = new ASTLength(Artist.ARTIST_NAME.path());
        Property<Integer> nameLength = Property.create("nameLength", exp, Integer.class);
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(nameLength.gt(5)).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
        Artist a3 = (Artist)ObjectSelect.query(Artist.class).where(nameLength.lt(5)).selectOne(this.context);
        TestCase.assertEquals(null, (Object)a3);
    }

    @Test
    public void testASTLocate() throws Exception {
        Artist a1 = this.createArtist("1267834567890abc");
        ASTScalar substr = new ASTScalar("678");
        ASTLocate exp = new ASTLocate(substr, Artist.ARTIST_NAME.path());
        Property<Integer> nameLoc = Property.create("nameLoc", exp, Integer.class);
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(nameLoc.eq(3)).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testCombinedFunction() throws Exception {
        Artist a1 = this.createArtist("absdefghij  klmnopq");
        ASTSubstring substring = new ASTSubstring(Artist.ARTIST_NAME.path(), new ASTScalar((Object)3), new ASTScalar((Object)10));
        ASTTrim trim = new ASTTrim(substring);
        ASTUpper upper = new ASTUpper(trim);
        ASTConcat concat = new ASTConcat(upper, new ASTScalar(" "), new ASTScalar("test"));
        Property<String> name = Property.create("substrName", concat, String.class);
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(name.eq("SDEFGHIJ test")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTConcatParse() {
        Expression exp = ExpressionFactory.exp("concat('abc', 'def')", new Object[0]);
        TestCase.assertEquals((Object)"abcdef", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTSubstringParse() {
        Expression exp = ExpressionFactory.exp("substring('123456789', 3, 2)", new Object[0]);
        TestCase.assertEquals((Object)"34", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTTrimParse() {
        Expression exp = ExpressionFactory.exp("trim(' abc ')", new Object[0]);
        TestCase.assertEquals((Object)"abc", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTLowerParse() {
        Expression exp = ExpressionFactory.exp("lower('AbC')", new Object[0]);
        TestCase.assertEquals((Object)"abc", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTUpperParse() {
        Expression exp = ExpressionFactory.exp("upper('aBc')", new Object[0]);
        TestCase.assertEquals((Object)"ABC", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTLocateParse() {
        Expression exp = ExpressionFactory.exp("locate('Bc', 'aBc')", new Object[0]);
        TestCase.assertEquals((Object)2, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testComplexParse() {
        Expression exp = ExpressionFactory.exp("locate(upper('Bc'), upper('aBc')) = length(substring(trim(lower(concat('   abc', 'def   '))), 3, 2))", new Object[0]);
        TestCase.assertEquals((Object)true, (Object)exp.evaluate(new Object()));
    }
}

