/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import org.apache.cayenne.exp.LikeExpressionHelper;
import org.apache.cayenne.exp.parser.ASTLike;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.junit.Assert;
import org.junit.Test;

public class LikeExpressionHelperTest {
    @Test
    public void testEscape_NoEscapeChars() {
        ASTLike node = new ASTLike(new ASTObjPath("x"), "abc");
        LikeExpressionHelper.escape(node);
        Assert.assertEquals((Object)"abc", (Object)node.getOperand(1));
        Assert.assertEquals((long)0L, (long)node.getEscapeChar());
    }

    @Test
    public void testEscape_OneChar() {
        ASTLike node = new ASTLike(new ASTObjPath("x"), "ab_c");
        LikeExpressionHelper.escape(node);
        Assert.assertEquals((Object)"ab!_c", (Object)node.getOperand(1));
        Assert.assertEquals((long)33L, (long)node.getEscapeChar());
    }

    @Test
    public void testEscape_TwoChars() {
        ASTLike node = new ASTLike(new ASTObjPath("x"), "ab_c_");
        LikeExpressionHelper.escape(node);
        Assert.assertEquals((Object)"ab!_c!_", (Object)node.getOperand(1));
        Assert.assertEquals((long)33L, (long)node.getEscapeChar());
    }

    @Test
    public void testEscape_TwoChars_Mix() {
        ASTLike node = new ASTLike(new ASTObjPath("x"), "ab%c_");
        LikeExpressionHelper.escape(node);
        Assert.assertEquals((Object)"ab!%c!_", (Object)node.getOperand(1));
        Assert.assertEquals((long)33L, (long)node.getEscapeChar());
    }

    @Test
    public void testEscape_AltEscapeChar1() {
        ASTLike node = new ASTLike(new ASTObjPath("x"), "a!%c");
        LikeExpressionHelper.escape(node);
        Assert.assertEquals((Object)"a!#%c", (Object)node.getOperand(1));
        Assert.assertEquals((long)35L, (long)node.getEscapeChar());
    }

    @Test
    public void testEscape_AltEscapeChar2() {
        ASTLike node = new ASTLike(new ASTObjPath("x"), "a!%c#_");
        LikeExpressionHelper.escape(node);
        Assert.assertEquals((Object)"a!$%c#$_", (Object)node.getOperand(1));
        Assert.assertEquals((long)36L, (long)node.getEscapeChar());
    }
}

