/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ExpressionFactoryIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    @Test
    public void testCollectionMatch() {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("artist");
        Painting p1 = this.context.newObject(Painting.class);
        Painting p2 = this.context.newObject(Painting.class);
        Painting p3 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        p2.setPaintingTitle("p2");
        p3.setPaintingTitle("p3");
        artist.addToPaintingArray(p1);
        artist.addToPaintingArray(p2);
        this.context.commitChanges();
        Assert.assertTrue((boolean)ExpressionFactory.matchExp("paintingArray", (Object)p1).match(artist));
        Assert.assertFalse((boolean)ExpressionFactory.matchExp("paintingArray", (Object)p3).match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.noMatchExp("paintingArray", (Object)p1).match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.noMatchExp("paintingArray", (Object)p3).match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.matchExp("paintingArray.paintingTitle", (Object)"p1").match(artist));
        Assert.assertFalse((boolean)ExpressionFactory.matchExp("paintingArray.paintingTitle", (Object)"p3").match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.noMatchExp("paintingArray.paintingTitle", (Object)"p1").match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.noMatchExp("paintingArray.paintingTitle", (Object)"p3").match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.inExp("paintingTitle", "p1").match(p1));
        Assert.assertFalse((boolean)ExpressionFactory.notInExp("paintingTitle", "p3").match(p3));
    }

    @Test
    public void testIn() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("p2");
        a1.addToPaintingArray(p1);
        a1.addToPaintingArray(p2);
        Expression in = ExpressionFactory.inExp("paintingArray", p1);
        Assert.assertTrue((boolean)in.match(a1));
    }

    @Test
    public void testEscapeCharacter() {
        if (!this.accessStackAdapter.supportsEscapeInLike()) {
            return;
        }
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("A_1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("A_2");
        this.context.commitChanges();
        Expression ex1 = ExpressionFactory.likeIgnoreCaseDbExp("ARTIST_NAME", "A*_1", '*');
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class, ex1);
        List<Artist> artists = this.context.select(q1);
        Assert.assertEquals((long)1L, (long)artists.size());
        Expression ex2 = ExpressionFactory.likeExp("artistName", (Object)"A*_2", '*');
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class, ex2);
        artists = this.context.select(q2);
        Assert.assertEquals((long)1L, (long)artists.size());
    }

    @Test
    public void testContains_Escape() {
        if (!this.accessStackAdapter.supportsEscapeInLike()) {
            return;
        }
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("MA_1X");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("CA%2Y");
        this.context.commitChanges();
        Expression ex1 = ExpressionFactory.containsExp(Artist.ARTIST_NAME.getName(), "A_1");
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class, ex1);
        List<Artist> artists = this.context.select(q1);
        Assert.assertEquals((long)1L, (long)artists.size());
        Expression ex2 = ExpressionFactory.containsExp(Artist.ARTIST_NAME.getName(), "A%2");
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class, ex2);
        artists = this.context.select(q2);
        Assert.assertEquals((long)1L, (long)artists.size());
    }

    @Test
    public void testDifferentExpressionAPI() throws Exception {
        Expression exp1 = ExpressionFactory.exp("length(substring(artistName, 1, 3)) > length(trim(artistName))", new Object[0]);
        List res = ObjectSelect.query(Artist.class, exp1).select(this.context);
        Assert.assertEquals((long)0L, (long)res.size());
        Expression exp2 = ExpressionFactory.greaterExp(FunctionExpressionFactory.lengthExp(FunctionExpressionFactory.substringExp(Artist.ARTIST_NAME.path(), 1, 3)), (Object)FunctionExpressionFactory.lengthExp(FunctionExpressionFactory.trimExp(Artist.ARTIST_NAME.path())));
        res = ObjectSelect.query(Artist.class, exp2).select(this.context);
        Assert.assertEquals((long)0L, (long)res.size());
        Property<Integer> lengthSub = Property.create(FunctionExpressionFactory.lengthExp(FunctionExpressionFactory.substringExp(Artist.ARTIST_NAME.path(), 1, 3)), Integer.class);
        Property<Integer> length = Property.create(FunctionExpressionFactory.lengthExp(FunctionExpressionFactory.trimExp(Artist.ARTIST_NAME.path())), Integer.class);
        Expression exp3 = lengthSub.gt(length);
        res = ObjectSelect.query(Artist.class, exp3).select(this.context);
        Assert.assertEquals((long)0L, (long)res.size());
        Assert.assertEquals((Object)exp1, (Object)exp2);
        Assert.assertEquals((Object)exp3, (Object)exp3);
    }
}

