/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class OracleResultSetMetadata
implements ResultSetMetaData {
    private ResultSetMetaData delegate;

    OracleResultSetMetadata(ResultSetMetaData delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.delegate.getCatalogName(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String className = this.delegate.getColumnClassName(column);
        if (BigDecimal.class.getName().equals(className) && this.getColumnType(column) == 4) {
            className = Integer.class.getName();
        }
        return className;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.delegate.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.delegate.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.delegate.getColumnLabel(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.delegate.getColumnName(column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int precision;
        int type = this.delegate.getColumnType(column);
        if (type == 2 && ((precision = this.delegate.getPrecision(column)) == 10 || precision == 38) && this.delegate.getScale(column) == 0) {
            type = 4;
        }
        return type;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.delegate.getColumnTypeName(column);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.delegate.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.delegate.getScale(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.delegate.getSchemaName(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.delegate.getTableName(column);
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.delegate.isAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.delegate.isCaseSensitive(column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.delegate.isCurrency(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.delegate.isDefinitelyWritable(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.delegate.isNullable(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.delegate.isReadOnly(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.delegate.isSearchable(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.delegate.isSigned(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.delegate.isWritable(column);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

