/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datafactory;

import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import org.apache.cayenne.datafactory.ValueProvider;

public class DataFactory {
    private Random random = ValueProvider.RANDOM;

    public String getFirstName() {
        return ValueProvider.FIRST_NAMES.randomValue();
    }

    public String getName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    public String getLastName() {
        return ValueProvider.LAST_NAMES.randomValue();
    }

    public String getStreetName() {
        return ValueProvider.STREET_NAMES.randomValue();
    }

    public String getStreetSuffix() {
        return ValueProvider.ADDRESS_SUFFIXES.randomValue();
    }

    public String getCity() {
        return ValueProvider.CITIES.randomValue();
    }

    public String getAddress() {
        int num = 404 + this.random.nextInt(1400);
        return num + " " + this.getStreetName() + " " + this.getStreetSuffix();
    }

    public String getAddressLine2() {
        int test = this.random.nextInt(100);
        if (test < 50) {
            return "Apt #100" + this.random.nextInt(1000);
        }
        return "Suite #100" + this.random.nextInt(1000);
    }

    public Date getBirthDate() {
        Date base = new Date(0L);
        return this.getDate(base, -5475, 5475);
    }

    public int getNumber() {
        return this.getNumberBetween(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int getNumberUpTo(int max) {
        return this.getNumberBetween(0, max);
    }

    public int getNumberBetween(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException(String.format("Minimum must be less than minimum (min=%d, max=%d)", min, max));
        }
        return min + this.random.nextInt(max - min);
    }

    public Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal.getTime();
    }

    public Date getDate(Date baseDate, int minDaysFromDate, int maxDaysFromDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        int diff = minDaysFromDate + this.random.nextInt(maxDaysFromDate - minDaysFromDate);
        cal.add(5, diff);
        return cal.getTime();
    }

    public Date getDateBetween(Date minDate, Date maxDate) {
        long seconds = (maxDate.getTime() - minDate.getTime()) / 1000L;
        seconds = (long)(this.random.nextDouble() * (double)seconds);
        Date result = new Date();
        result.setTime(minDate.getTime() + seconds * 1000L);
        return result;
    }

    public String getRandomText(int length) {
        return this.getRandomText(length, length);
    }

    public String getRandomText(int minLength, int maxLength) {
        this.validateMinMaxParams(minLength, maxLength);
        StringBuilder sb = new StringBuilder(maxLength);
        int length = minLength;
        if (maxLength != minLength) {
            length += this.random.nextInt(maxLength - minLength);
        }
        while (length > 0) {
            if (sb.length() != 0) {
                sb.append(" ");
                --length;
            }
            String word = this.getRandomWord();
            sb.append(word);
            length -= word.length();
        }
        if (sb.length() < maxLength) {
            return sb.toString();
        }
        return sb.substring(0, maxLength);
    }

    private void validateMinMaxParams(int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("Minimum length must be a non-negative number");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Maximum length must be a non-negative number");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException(String.format("Minimum length must be less than maximum length (min=%d, max=%d)", minLength, maxLength));
        }
    }

    public char getRandomChar() {
        return (char)(this.random.nextInt(26) + 97);
    }

    public String getRandomChars(int length) {
        return this.getRandomChars(length, length);
    }

    public String getRandomChars(int minLength, int maxLength) {
        this.validateMinMaxParams(minLength, maxLength);
        StringBuilder sb = new StringBuilder(maxLength);
        int length = minLength;
        if (maxLength != minLength) {
            length += this.random.nextInt(maxLength - minLength);
        }
        while (length > 0) {
            sb.append(this.getRandomChar());
            --length;
        }
        return sb.toString();
    }

    public String getRandomWord() {
        return ValueProvider.WORDS.randomValue();
    }

    public String getSuffix(int chance) {
        return ValueProvider.suffixes.randomValue(chance);
    }

    public String getPrefix(int chance) {
        return ValueProvider.prefixes.randomValue(chance);
    }

    public String getNumberText(int digits) {
        StringBuilder result = new StringBuilder(digits);
        for (int i = 0; i < digits; ++i) {
            result.append(this.random.nextInt(10));
        }
        return result.toString();
    }

    public String getEmailAddress() {
        return this.getLogin() + "@" + ValueProvider.EMAIL_HOSTS.randomValue() + "." + ValueProvider.TLDS.randomValue();
    }

    public String getLogin() {
        int test = this.random.nextInt(100);
        String login = test < 20 ? this.getFirstName().charAt(0) + this.getLastName() : (test < 40 ? this.getFirstName() + "." + this.getLastName() : (test < 45 ? this.getFirstName() + "_" + this.getLastName() : (test < 55 ? this.getLastName() : this.getRandomWord() + this.getRandomWord())));
        if (this.random.nextInt(100) > 80) {
            login = login + this.random.nextInt(100);
        }
        return login;
    }

    public boolean chance(int chance) {
        return this.random.nextInt(100) < chance;
    }

    public void randomize(int seed) {
        this.random = new Random(seed);
    }
}

